<?php
/**
 * @package    Well.Unireg
 * @subpackage Components
 * @link http://www.wellhome.sk
 * @license    GNU/GPL for non-commercial use
*/

// no direct access
defined( '_FEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.controller');

/**
 * The main Unireg Component Controller
 *
 * @package    Well.Unireg
 * @subpackage Components
 */
class UniregControllerFolder extends FController
{	
	function isMyType($mytype) {
    	$item = $this->getModel('item');    	
    	$type = $item->getType();
    	return ($type == $mytype);
	}

	function __construct() {
		parent::__construct();

    	//Maps addCategory to editCategory
    	$this->registerTask( 'addfolder'  ,     'editfolder' );
	}
	
	/**
     * Method to display the view
     *
     * @access    public
     */
    function display()
    {
    	if (!$this->isMyType('folder')) {
			$link = 'index.php?option=com_unireg'; 
			$this->setRedirect($link, 'You chose an incorrect controller in the URL.');    		
    		return;
    	}
    	
		FRequest::setVar( 'view', 'items' );    	    	
       	parent::display();
        
    }
	
	function editFolder() {
    	if ( FRequest::getInt('iid') > 0 )
			if (!$this->isMyType('folder')) {
				$link = 'index.php?option=com_unireg'; 
				$this->setRedirect($link, 'You chose an incorrect controller in the URL.');    		
	    		return;
    	}
    	
		FRequest::setVar( 'view', 'folder' );
    	FRequest::setVar( 'layout', 'form'  );
    	    	
		parent::display();
	}
	
	function save() {
		$model = $this->getModel('folder');

		if (FRequest::getWord('cancel') != 'Cancel') {
		    if ($model->store()) {
		        $msg = FText::_( 'Category Saved!' );
		    } else {
		        $msg = FText::_( 'Error Saving Category' );
		    }
		} else {
			$msg = FText::_( 'Category change canceled' );
		}

	    // Check the table in so it can be edited.... we are done with it anyway
	    $link = 'index.php?option=com_unireg&iid='.FRequest::getInt('pid').'&Itemid='
	    		.FRequest::getInt('Itemid');
	    $this->setRedirect($link, $msg);		
	}
	
	function showDetails() {
    	if (!$this->isMyType('folder')) {
			$link = 'index.php?option=com_unireg&Itemid='
	    		.FRequest::getInt('Itemid'); 
			$this->setRedirect($link, 'You chose an incorrect controller in the URL.');    		
    		return;
    	}

		FRequest::setVar( 'view', 'folder' );
    	FRequest::setVar( 'layout', 'details'  );
    	    	
		parent::display();
	}
}
?>