<?php
class UToolbar {
	var $url;
	var $rightbuttons = array();
	var $leftbuttons = array();	
	var $iid;
	
	function UToolbar() {
		$document = &FFactory::getDocument();
		$document->addStyleSheet(FPATH_COMPONENT_RELATIVE_URI.'toolbar/css/default.css');

		$this->prepareButtons();
	}
	
	function addButton($type) {
		$this->url->setVar('controller',$type);
		$this->url->setVar('task','add'.$type);
		$this->url->setVar('pid', $this->iid);
		$this->url->setVar('iid','0');
		$query = $this->url->getQuery();
		
		$this->url->setVar('iid', $this->iid);
		
		$path = FPATH_COMPONENT_RELATIVE_URI.'/toolbar/icons/'.$type.'.png';
		
		switch ($type) {
			case 'entry': $n = 'Nový záznam'; break;
			case 'folder': $n = 'Nový priečinok'; break;
			case 'category': $n = 'Nová kategória'; break;
			default: $n = 'Nový';
		}
		
		$new = array('iconpath' => $path, 'name' => $n, 'type' => $type, 'query' => $query);
		array_push($this->rightbuttons, $new);
	}
	
	function addUpButton() {
		$query = 'option=com_unireg&task=levelup&iid='.FRequest::getInt('iid').'&Itemid='.FRequest::getInt('Itemid');
		
		$path = FPATH_COMPONENT_RELATIVE_URI.'/toolbar/icons/go-up.png';
		$new = array('iconpath' => $path, 'name' => 'Hore', 'query' => $query);
		array_push($this->leftbuttons, $new);	
	}
	
	function canAddButton($type) {
		if (FRequest::getInt('iid') == 0) {
			if (($type == 'entry') or ($type == 'folder')) {
				return false;
			}
		}
		
		return true;
	}
	
	function prepareButtons() {
		$this->url = FURI::getInstance();
		$this->iid = $this->url->getVar( 'iid' );
		/*$this->url->setVar(name, value);
		$this->url->getQuery()*/		
		
		$db = & FFactory::getDBO();
		$query = 'SELECT single '
				.'FROM #__unireg_types ';
		$db->setQuery($query);
		$res = $db->loadRowList();
		
		foreach ($res as $row) {
			if ($this->canAddButton($row[0]))
				$this->addButton($row[0]);
		}
		
		if ( $this->iid != 0 )
			$this->addUpButton();
	}
	
	function render() {
		require('html/default.php');
	}
}
?>