<?php
/**
 * @package    Well.Unireg
 * @subpackage Components
 * @link http://www.wellhome.sk
 * @license    GNU/GPL for non-commercial use
*/

// no direct access
defined( '_FEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.controller');

/**
 * The main Unireg Component Controller
 *
 * @package    Well.Unireg
 * @subpackage Components
 */
class UniregController extends FController
{
    /**
     * Method to display the view
     *
     * @access    public
     */
    function display()
    {	
    	$item = $this->getModel('item');
    	
    	$type = $item->getType();

    	
    	$path = FPATH_COMPONENT.DS.'controllers'.DS.$type.'.php';
		if (file_exists($path)) {
			$uri = FURI::getInstance();
			$uri->setVar('controller',$type);
			$link = 'index.php?'.$uri->getQuery();
			//$this->setRedirect($link, $msg);
			$this->setRedirect($link);
		} else {
			FRequest::setVar('iit','0');
			FRequest::setVar( 'view', 'items' );    	    	
        	parent::display();
		}        
    }
    
	/**
	 * Method to move one level up when browsing the directory tree
	 *
	 */
    function levelup() {
    	
    	$item = $this->getModel('item');

    	$link = 'index.php?option=com_unireg&iid='.$item->getParentID().'&Itemid='.FRequest::getInt('Itemid');
    	
		$this->setRedirect($link);    	
    }
    
    function delete() {
    	
    	$item = $this->getModel('item');
    	$parent = $item->getParentID();
    	if ($item->delete())
    		$msg = 'The item was deleted';
    	else
    		$msg = 'An error occured; the item was not deleted';
    	$link = 'index.php?option=com_unireg&iid='.$parent.'&Itemid='.FRequest::getInt('Itemid');
    	
    	$this->setRedirect($link,$msg);
    }
}
?>