<?php
/**
 * Categories Model for Unireg Component
 * 
 * @package    Joomla.Tutorials
 * @subpackage Components
 * @link http://dev.joomla.org/component/option,com_jd-wiki/Itemid,31/id,tutorials:modules/
 * @license    GNU/GPL
 */

// Check to ensure this file is included in Joomla!
defined('_FEXEC') or die();

/**
 * Categories Model
 *
 * @package    Well.Unireg
 * @subpackage Components
 */
class UniregModelCategory extends FModel
{

	/**
     * Hellos data array
     *
     * @var array
     */
	var $_data;
	var $item_id;
	
	/**
	 * Overrides the parent-class constructor
	 * as we need to use a parameter category_id
	 */
	function __construct() {
		
		parent::__construct();
		
		$this->item_id = FRequest::getInt('iid');
	}
	
	/**
     * Returns the query
     * @return string The query to be used to retrieve the rows from the database
     */
    function _buildQuery()
    {
        $query = 'SELECT Items.id AS iid, Items.pid, Items.rid, Cat.title, Cat.name, Cat.description '
        		.'FROM #__unireg_items AS Items INNER JOIN #__unireg_categories AS Cat '
        		.'ON Items.rid=Cat.id '
        		.'WHERE Items.id='.$this->item_id;
        return $query;
    }

    /**
     * Retrieves the hello data
     * @return array Array of objects containing the data from the database
     */
    function getData()
    {
        //$this->category_id = JRequest::getInt('cid');
    	
		if ($this->item_id > 0 ) {
        	// Lets load the data if it doesn't already exist
	        if (empty( $this->_data ))
	        {
	            $query = $this->_buildQuery();
	            $this->_db->setQuery( $query );
	            $this->_data = $this->_getList( $query );            
	            //$this->_data = $this->_db->loadResult();            
	        }
		} else {
			$this->_data = array();
	        $this->_data[0] = new stdClass();
	        $this->_data[0]->iid = 0;
	        $this->_data[0]->pid = FRequest::getInt('pid');
	        $this->_data[0]->rid = 0;
	        $this->_data[0]->title = null;
	        $this->_data[0]->name = null;
	        $this->_data[0]->description = null;     			
		}

        return $this->_data;
    }
    
    function getDescription() {
        if (empty( $this->_data ))
        {
            $query = $this->_buildQuery();
            //$this->_data = $this->_getList( $query );
            $this->_db->setQuery( $query );
            $this->_data = $this->_db->loadResult();            
        }

        return $this->_data;    	
    }
        
	/**
	 * Method to store a record
	 *
	 * @access    public
	 * @return    boolean    True on success
	 */
	function store() {
		
	    $data = JRequest::get( 'post' );

	    if ($data['iid'] != 0) {
		    $query = 'UPDATE #__unireg_categories AS Cat '
		    		.'SET name=\''.$data['name'].'\', title=\''.$data['title'].'\', description=\''.$data['description'].'\' '
		    		.'WHERE Cat.id='.$data['rid'];
		    
		    $db = & FFactory::getDBO();
		    $db->setQuery($query);
		    $res = $db->query();
	    
	    } else {
	    	require_once(FPATH_COMPONENT.DS.'models'.DS.'item.php');
//	    	$item = $this->getModel('item');
	    	$type_id = UniregModelItem::getID('category');
	    	
	    	//first query to insert into categories table
	    	$query = 'INSERT INTO #__unireg_categories (name, title, description) '
					.'VALUES (\''.$data['name'].'\', \''.$data['title'].'\', \''.$data['description'].'\')';
			$db = & FFactory::getDBO();
			$db->setQuery($query);
			$res = $db->query();
			
			$real_id = $db->insertid();
			
			//second query to insert into items table
	    	$query = 'INSERT INTO #__unireg_items (pid, type_id, rid) '
					.'VALUES (\''.$data['pid'].'\', \''.$type_id.'\', \''.$real_id.'\')';
				$db = & FFactory::getDBO();
			$db->setQuery($query);
			$res = $db->query();
	    }
	    
	    return $res == true;
	}
}