<?php
/**
 * Categories Model for Unireg Component
 * 
 * @package    Joomla.Tutorials
 * @subpackage Components
 * @link http://dev.joomla.org/component/option,com_jd-wiki/Itemid,31/id,tutorials:modules/
 * @license    GNU/GPL
 */

// Check to ensure this file is included in Joomla!
defined('_FEXEC') or die();

/**
 * Categories Model
 *
 * @package    Well.Unireg
 * @subpackage Components
 */
class UniregModelEntry extends FModel
{

	/**
     * Hellos data array
     *
     * @var array
     */
	var $_data;
	var $item_id;
	var $entry_id;
	var $_files;
	
	/**
	 * Overrides the parent-class constructor
	 * as we need to use a parameter category_id
	 */
	function __construct() {
		
		parent::__construct();
		
		$this->item_id = FRequest::getInt('iid');
	}
	
	/**
     * Returns the query
     * @return string The query to be used to retrieve the rows from the database
     */
    function _buildQuery()
    {
        $query = 'SELECT Items.id AS iid, Items.pid, Items.rid, Rec.modified, Rec.created, Rec.name, Rec.description '
        		.'FROM #__unireg_items AS Items INNER JOIN #__unireg_entries AS Rec '
        		.'ON Items.rid=Rec.id '
        		.'WHERE Items.id='.$this->item_id;
        return $query;
    }

    /**
     * Retrieves the hello data
     * @return array Array of objects containing the data from the database
     */
    function getData()
    {
        //$this->category_id = JRequest::getInt('cid');
    	
		if ($this->item_id > 0 ) {
        	// Lets load the data if it doesn't already exist
	        if (empty( $this->_data ))
	        {
	            $query = $this->_buildQuery();
	            $this->_db->setQuery( $query );
	            $this->_data = $this->_getList( $query );            
	            //$this->_data = $this->_db->loadResult();            
	        }
		} else {
			$this->_data = array();
	        $this->_data[0] = new stdClass();
	        $this->_data[0]->iid = 0;
	        $this->_data[0]->pid = FRequest::getInt('pid');
	        $this->_data[0]->rid = 0;
	        $this->_data[0]->name = null;
	        $this->_data[0]->description = null;
	        $this->_data[0]->modified = null;
	       	$this->_data[0]->created = null;
	        
		}

        return $this->_data;
    }
            
	/**
	 * Method to store a entry
	 *
	 * @access    public
	 * @return    boolean    True on success
	 */
	function store() {
		
	    $data = JRequest::get( 'post' );
		
	    if ($data['pid'] == 0)
	    	return false;
	    
	    if ($data['iid'] != 0) {
		    $query = 'UPDATE #__unireg_entrys AS Rec '
		    		.'SET name=\''.$data['name'].'\', description=\''.$data['description'].'\', '
		    		.'created=\''.$data['created'].'\', modified=\''.$data['modified'].'\' '
		    		.'WHERE Rec.id='.$data['rid'];
		    
		    $db = & FFactory::getDBO();
		    $db->setQuery($query);
		    $res = $db->query();
	    
	    } else {
	    	require_once(FPATH_COMPONENT.DS.'models'.DS.'item.php');
//	    	$item = $this->getModel('item');
	    	$type_id = UniregModelItem::getID('entry');
	    	
	    	//first query to insert into categories table
	    	$query = 'INSERT INTO #__unireg_entries (name, description, created, modified) '
					.'VALUES (\''.$data['name'].'\', \''.$data['description'].'\', '
					.'\''.$data['created'].'\', \''.$data['modified'].'\' )';
			$db = & FFactory::getDBO();
			$db->setQuery($query);
			$res = $db->query();
			
			$real_id = $db->insertid();
			
			//second query to insert into items table
	    	$query = 'INSERT INTO #__unireg_items (pid, type_id, rid) '
					.'VALUES (\''.$data['pid'].'\', \''.$type_id.'\', \''.$real_id.'\')';
				$db = & FFactory::getDBO();
			$db->setQuery($query);
			$res = $db->query();
	    }
	    
	    return $res == true;
	}
	
	function getentryID() {
		$query = 'SELECT Rec.id '
				.'FROM #__unireg_items AS Items INNER JOIN #__unireg_entries AS Rec '
				.'ON Items.rid=Rec.id '
				.'WHERE Items.id='.$this->item_id;
		$db = & FFactory::getDBO();
		$db->setQuery($query);
		return $db->loadResult();
	}
	
/**
 * The following methods are about files:
 */
 
	function getFiles() {
		if (!isset($this->entry_id))
			$this->entry_id = $this->getentryID();
		
		if (empty($this->_files)) {
			$query = 'SELECT Fil.id, Fil.entry_id, Fil.name, Fil.filename, Fil.path, Fil.note, Fil.mime '
				.'FROM #__unireg_entries AS Rec INNER JOIN #__unireg_recfiles AS Fil '
				.'ON Rec.id=Fil.entry_id '
				.'WHERE Rec.id='.$this->entry_id;
		
		    $this->_db->setQuery( $query );
		    $this->_files = $this->_getList( $query );
		}

		return $this->_files;
	}
	
	/**
	 * Saves the file info to the DB
	 *
	 * @param string $dir
	 * @param string $mime Mime media type
	 */
	function saveFileDB($rec_id, $name, $filename, $dir, $mime) {
		$query = 'INSERT INTO #__unireg_recfiles '
				.'(entry_id, name, filename, path, mime) '
				.'VALUES (\''.$rec_id.'\',\''.$name.'\',\''.$filename.'\',\''.$dir.'\',\''.$mime.'\') ';
		$db = FFactory::getDBO();
		$db->setQuery($query);
		return $db->query();
	}
}
