<?php
/**
 * Categories Model for Unireg Component
 * 
 * @package    Joomla.Tutorials
 * @subpackage Components
 * @link http://dev.joomla.org/component/option,com_jd-wiki/Itemid,31/id,tutorials:modules/
 * @license    GNU/GPL
 */

// Check to ensure this file is included in Joomla!
defined('_FEXEC') or die();

/**
 * Categories Model
 *
 * @package    Well.Unireg
 * @subpackage Components
 */
class UniregModelItem extends FModel
{

	/**
     * Items data array
     *
     * @var array
     */
	var $_data;
	var $item_id;
	
	/**
	 * Overrides the parent-class constructor
	 * as we need to use a parameter category_id
	 */
	function __construct() {
		
		parent::__construct();
		
		$this->item_id = FRequest::getInt('iid');
	}
	
	/**
     * Returns the query
     * @return string The query to be used to retrieve the rows from the database
     */
    function _buildQuery()
    {
    	
   		$query = 'SELECT Typ.single '
   				.'FROM #__unireg_items AS Items INNER JOIN #__unireg_types AS Typ '
       			.'ON Items.type_id=Typ.id '
       			.'WHERE id='.$this->item_id;        
        		
        return $query;        
    }
    
    /**
     * Retrieves the type of the item with item_id  
     *
     */
    function getType() {
    	
    	$query = 'SELECT Types.single '
    			.'FROM #__unireg_items AS Items INNER JOIN #__unireg_types AS Types '
    			.'ON Items.type_id = Types.id '
    			.'WHERE Items.id = '.$this->item_id.' ';    	
    	$db = & FFactory::getDBO();
		$db->setQuery( $query );

		//getting the result
		//$result = $db->loadRowList();
		$result = $db->loadResult();
		
		return $result;
    }
    
    function getTable() {
    	$query = 'SELECT Types.tablename '
    			.'FROM #__unireg_items AS Items INNER JOIN #__unireg_types AS Types '
    			.'ON Items.type_id = Types.id '
    			.'WHERE Items.id = '.$this->item_id.' ';    	
    	$db = & FFactory::getDBO();
		$db->setQuery( $query );

		//getting the result
		//$result = $db->loadRowList();
		$result = $db->loadResult();
		
		return $result;
    }
    
    /**
     * This function is called usually as static and returns type ID of a type
     *
     * @param string $typename This is a singular of the type name, e.g. folder (not folders)
     * @return int The ID of the type
     */
    function getID($typename) {    	
   		$query = 'SELECT Typ.id '
   				.'FROM #__unireg_types AS Typ '
       			.'WHERE Typ.single=\''.$typename.'\'';
       	$db = FFactory::getDBO();
       	$db->setQuery($query);
       	$result = $db->loadResult();

       	return $result;    	
    }
    
    /**
     * Retrieves the hello data
     * @return array Array of objects containing the data from the database
     */
    function getData()
    {
        //$this->category_id = JRequest::getInt('cid');
    	
    	// Lets load the data if it doesn't already exist
        if (empty( $this->_data ))
        {
        	
            $query = $this->_buildQuery();
            $this->_data = $this->_getList( $query );
        }

        return $this->_data;
    }
    
    function getParentID() {    	
    	$query = 'SELECT pid '
    			.'FROM #__unireg_items '
    			.'WHERE id='.$this->item_id;
    			
     	$db = & FFactory::getDBO();
		$db->setQuery( $query );

		//getting the result
		//$result = $db->loadRowList();
		$result = $db->loadResult();
		
		if (empty($result))
			return 0;
		
		return $result;   			
    }
    
    function getChildren($id = -1) {
    	if ($id == -1)
    		$id = $this->item_id;
    	
    	$query = 'SELECT Items.id, Typ.tablename '
    			.'FROM #__unireg_items AS Items INNER JOIN #__unireg_types AS Typ '
    			.'ON Items.type_id=Typ.id '
    			.'WHERE Items.pid='.$id;
    			
    	$db = FFactory::getDBO();
    	$db->setQuery($query);
    	$res = $db->loadRowList();
    	
    	return $res;
    }
    
    /**
     * Deletes item from two tables:
     * 		#__unireg_items
     * 		specific table
     *
     * @param Array() $item array of 2 vars: id in items table & table name
     */
    function deleteItem($item) {
    	$query = 'DELETE Items, Tab '
    			.'FROM #__unireg_items AS Items INNER JOIN #__'.$item[1].' AS Tab '
    			.'ON Items.rid=Tab.id '
    			.'WHERE Items.id='.$item[0];
    			
    	$db = FFactory::getDBO();
    	$db->setQuery($query);
    	$res = $db->query();
    	//$res = $db->getRowList();    	
    }
    
    function delete() {
    	if ($this->item_id == 0)
    		return false;
    	
    	require_once('stack/deletestack.php');
    	$stack = new Stack();
    	
    	$stack->push(array($this->item_id,$this->getTable()));
    	
    	while (!$stack->isEmpty()) {
    		$parent = $stack->top();
    		$children = $this->getChildren($parent[0]);
    		
    		if (!empty($children)) {
	    		foreach ($children as $child) {
	    			$stack->push($child);
	    		}    			
    		} else {
    			$this->deleteItem($stack->pop());
    		}
    	}
    	return true;
    }
}