<?php
/**
 * Categories Model for Unireg Component
 * 
 * @package    Joomla.Tutorials
 * @subpackage Components
 * @link http://dev.joomla.org/component/option,com_jd-wiki/Itemid,31/id,tutorials:modules/
 * @license    GNU/GPL
 */

// Check to ensure this file is included in Joomla!
defined('_FEXEC') or die();

/**
 * Categories Model
 *
 * @package    Well.Unireg
 * @subpackage Components
 */
class UniregModelItems extends FModel
{

	/**
     * Items data array
     *
     * @var array
     */
	var $_data;
	var $item_id;
	var $types;
	
	/**
	 * Overrides the parent-class constructor
	 * as we need to use a parameter category_id
	 */
	function __construct() {
		
		parent::__construct();
		
		$this->item_id = FRequest::getInt('iid');
	}
	
	/**
     * Returns the query
     * @return string The query to be used to retrieve the rows from the database
     */
    function _buildQuery()
    {
    	if (empty( $this->types )) {
    		$this->loadTypes();
    	}
    	
    	$query = '';
    	$select = '';
    	$union = '';
    	
    	/**
    	 * In this loop we unite results from many tables to one result
    	 */
    	foreach ($this->types as $key => $row) {    		
    		$select = 'SELECT Items.id AS idx, Items.type_id AS tidx, Tab'.$key.'.name AS namex '
    				.'FROM #__unireg_items AS Items INNER JOIN #__'.$row['tablename'].' AS Tab'.$key.' '
        			.'ON Items.rid=Tab'.$key.'.id AND Items.type_id='.$row['id'].' '
        			.'WHERE Items.pid='.$this->item_id;
        	$query = $query.$union.$select;
        	$union = ' UNION ';
    	}
        
        		
        return $query;        
    }
    
    /**
     * Retrieves the hello data
     * @return array Array of objects containing the data from the database
     */
    function getData()
    {
        //$this->category_id = JRequest::getInt('cid');
    	
    	// Lets load the data if it doesn't already exist
        if (empty( $this->_data ))
        {
        	if ( empty( $this->types )) {
        		$this->loadTypes();
        	}
            $query = $this->_buildQuery();
            $this->_data = $this->_getList( $query );
        }

        return $this->_data;
    }
    
    /**
     * Loads types, which are relevant for this particular item, from DB
     *
     * @return array Array of different types with id, name, db name
     */
    function loadTypes() {
    	$result = array();
    	
    	$query = 'SELECT Types.id, single, tablename '
    			.'FROM #__unireg_items AS Items INNER JOIN #__unireg_types AS Types '
    			.'ON Items.type_id = Types.id '
    			.'WHERE Items.pid = '.$this->item_id.' '
    			.'GROUP BY Types.id';

    	$db = FFactory::getDBO();
    	$db->setQuery( $query );

		//getting the result
		$res = $db->loadRowList();
		
		foreach ($res as $row) {
			$result[$row[0]]['id'] = $row[0];	
			$result[$row[0]]['single'] = $row[1];
			$result[$row[0]]['tablename'] = $row[2];
		}
		
		$this->types = $result;    	
    }
    
    function getTypes() {
    	if ( empty( $this->types )) {
    		$this->loadTypes();
    	}
    	
    	return $this->types;
    }
}