<?php

// Check to ensure this file is included in Joomla!
defined('_FEXEC') or die();

class UniregModelTypes extends FModel {
	
	/**
     * Types data array
     *
     * @var array
     */
	var $_data;
	
	function __construct() {
		parent::__construct();
		
		//// loads data from DB to _data variable
		//$this->setTypes();
	}
	
	/**
	 * Loads types data from DB to _data variable 
	 *
	 * @return array 2-dimensional array where first indexes are id-s and sub-arrays
	 * are indexed according to the names of columns 
	 */
	function setTypes() {
		$db = FFactory::getDBO();
		$query = 'SELECT id, single, tablename '
				.'FROM #__unireg_types ';
		$db->setQuery($query);
		$res = $db->loadRowList();
		
		// an array to get transformed data into
		$result = array();
		
		/**
		 * Transforming data to a more pleasing form :
		 * indexes are id-s from the table 
		 */ 
		foreach ($res as $key => $row) {
			$result[$row[0]]['id'] = $row[0];
			$result[$row[0]]['single'] = $row[1];
			$result[$row[0]]['tablename'] = $row[2];		
		}
		
		$this->_data = $result;
	}
	
	function getData() {
	    
		if (empty( $this->_data )) {            
            $this->setTypes();
        }

        return $this->_data;
    }		
	
	function getType($id) {
		return $this->_data[$id];
	}
	
    /**
     * Retrieves the type of the current viewed item.
     * @return string The name of the type
     */
/*	function getType() {
		$db = & JFactory::getDBO();
		
		if ($this->item_id > 0) {
	    	$query = 'SELECT Types.single '
	    			.'FROM #__unireg_items AS Items INNER JOIN #__unireg_types AS Types '
	    			.'ON Items.type_id = Types.id '
	    			.'WHERE Items.id = '.$this->item_id;
			
			$db->setQuery( $query );
	
			//getting the result
			$result = $db->loadResult();
			//$result = $db->loadRowList();
		} else {
			$result = '';    			
		}
    	return $result;
    }
*/
}
?>