//						
//					    .-=-==--==--.
//					..-=="  ,'o`)      `.
//					,'         `"'         \
//					:  (                     `.__...._
//					|                  )    /         `-=-.
//					:       ,vv.-._   /    /               `---==-._
//					\/\/\/VV ^ d88`;'    /                         `.
//					``  ^/d88P!'    /             ,              `._
//			WRRRRR	   ^/    !'   ,.      ,      /                  "-,,__,,--'""""-.
//			WRRRRR	  ^/    !'  ,'  \ . .(      (         _           )  ) ) ) ))_,-.\
//					 ^(__ ,!',"'   ;:+.:%:a.     \:.. . ,'          )  )  ) ) ,"'    '
//					 ',,,'','     /o:::":%:%a.    \:.:.:         .    )  ) _,'
//					  """'       ;':::'' `+%%%a._  \%:%|         ;.). _,-""
//					         ,-='_.-'      ``:%::)  )%:|        /:._,"
//					        (/(/"           ," ,'_,'%%%:       (_,'
//					                       (  (//(`.___;        \
//					                        \     \    `         `
//					                         `.    `.   `.        :
//					                           \. . .\    : . . . :
//					                            \. . .:    `.. . .:
//					                             `..:.:\     \:...\
//					                              ;:.:.;      ::...:
//					                              ):%::       :::::;
//					                          __,::%:(        :::::
//					                       ,;:%%%%%%%:        ;:%::
//					                         ;,--""-.`\  ,=--':%:%:\
//					                        /"       "| /-".:%%%%%%%\
//					                                        ;,-"'`)%%)   (
//					                                       /"      "|

import java.util.ArrayList;

public class ConditionsSRG {
	
	public int[][] additionMatrix(int a[][], int b[][], char ch) {

		int aRows = a.length;
		int bColumns = b[0].length;

		int[][] result = new int[aRows][bColumns];
		
		for (int i = 0; i < aRows; i++) {
			for (int j = 0; j < bColumns; j++) {
				if (ch == '+') result[i][j] = a[i][j] + b[i][j];
				if (ch == '-') result[i][j] = a[i][j] - b[i][j];
			}
		}
		
		return result;
	}

	
	public int[][] multiply(int a[][], int b[][]) {

		int aRows = a.length;
		int aColumns = a[0].length;
//		int bRows = b.length;
		int bColumns = b[0].length;

		int[][] result = new int[aRows][bColumns];

		for (int i = 0; i < aRows; i++) {
			for (int j = 0; j < bColumns; j++) {
				for (int k = 0; k < aColumns; k++) { 
					result[i][j] += a[i][k] * b[k][j];
				}
			}
		}
		return result;
	}

	public int[][] transposeMatrix(int a[][]){
		int rows = a.length;
		int columns = a[0].length; 
		int[][] result = new int[rows][columns];
		
		for(int i=0; i < rows; i++){
			for(int j=0; j < columns; j++){
				result[i][j] = a[j][i];
			}
		}
		
		return result;
	}
	
	public int[][] multiplyConst_Matrix(int c, int a[][]){
		int rows = a.length;
		int columns = a[0].length; 
		int[][] result = new int[rows][columns];
		
		for(int i=0; i < rows; i++){
			for(int j=0; j < columns; j++){
				result[i][j] = c*a[i][j];
			}
		}
		
		return result;
	}
	
	public Boolean checkAll_OneMatrix(int number, int[][] matrix){
		Boolean test = true;
		for(int i=0;i<matrix.length;i++){
			for(int j=0; j<matrix.length; j++){
				if (matrix[i][j]!=number) {
					test = false;
					break;
				}
			}
		}
		return test;
	}
	
	public Boolean checkNumber_of_OneMatrix(int number, int[][] matrix){
		Boolean test = true;
		for(int i=0; i< matrix.length; i++){
			int sucet = 0;
			for(int j=0; j< matrix.length; j++){
				if (matrix[i][j]==1) sucet += 1;
			}
			if (sucet!=number) {
				test = false;
				break;
			}
		}
		
		for(int i=0; i< matrix.length; i++){
			int sucet = 0;
			for(int j=0; j< matrix.length; j++){
				if (matrix[j][i]==1) sucet += 1;
			}
			if (sucet!=number) {
				test = false;
				break;
			}
		}
		return test;
	}

	public static void main(String[] args) throws Exception {
		
		ConditionsSRG conditionsSRG = new ConditionsSRG();
		Multiplication multiplication = new Multiplication();
		multiplication.getSolution();
		MySRGIsomorphism mySRGIsomorphism = new MySRGIsomorphism();
		mySRGIsomorphism.readMySrg("srg-non_iso.txt");
		ArrayList<int[][]> graphs = new ArrayList<int[][]>();
		graphs = MySRGIsomorphism.srg_matrices;
		
		int[][] identity_matrix = new int[12][12];
		for(int i=0; i<12; i++){
			for(int j=0; j<12; j++){
				if (i==j) identity_matrix[i][j] = 6;
			}
		}
		int pocet = 0;
		
		for(int i=0; i<graphs.size(); i++){
			
			Boolean test = true;
			
			System.out.println("Graf: " + i);
			int[][] srg_matrix = graphs.get(i);
			int[][] matrix_A = new int[12][12];
			int[][] matrix_C = new int[12][12];
			int[][] matrix_B = new int[12][12];
			
//			matrix_A = multiplication.a1_matrices_fixed.get(9712);
//			matrix_C = multiplication.a2_matrices.get(9712);
			
			for(int j=1;j<13;j++){
				for(int k=1;k<13;k++){
					matrix_A[j-1][k-1] = srg_matrix[j][k];
				}
			}
			
			for(int j=13;j<25;j++){
				for(int k=13;k<25;k++){
					matrix_C[j-13][k-13] = srg_matrix[j][k];
				}
			}
			
			for(int j=13;j<25;j++){
				for(int k=1;k<13;k++){
					matrix_B[j-13][k-1] = srg_matrix[j][k];
				}
			}
			
			int[][] tmp1_q1 = conditionsSRG.additionMatrix(conditionsSRG.multiply(matrix_A, matrix_A), matrix_A, '+');
			int[][] tmp2_q1 = conditionsSRG.additionMatrix(tmp1_q1, identity_matrix, '-');
			int[][] q1 = conditionsSRG.additionMatrix(tmp2_q1, conditionsSRG.multiply(conditionsSRG.transposeMatrix(matrix_B), matrix_B), '+');
			
			int[][] tmp1_q2 = conditionsSRG.additionMatrix(conditionsSRG.multiply(matrix_C, matrix_C), matrix_C, '+');
			int[][] tmp2_q2 = conditionsSRG.additionMatrix(tmp1_q2, identity_matrix, '-');
			int[][] q2 = conditionsSRG.additionMatrix(tmp2_q2, conditionsSRG.multiply(matrix_B, conditionsSRG.transposeMatrix(matrix_B)), '+');
			
			int[][] tmp1_l = conditionsSRG.additionMatrix(conditionsSRG.multiply(matrix_B, matrix_A), conditionsSRG.multiply(matrix_C, matrix_B), '+');
			int[][] lin = conditionsSRG.additionMatrix(tmp1_l, matrix_B, '+');
			System.out.println("Pocet jednotiek v riadkoch a stlpcoch: " + conditionsSRG.checkNumber_of_OneMatrix(12, srg_matrix));
			System.out.println("1. Kvadraticka podmienka: "+ conditionsSRG.checkAll_OneMatrix(5, q1));
			System.out.println("2. Kvadraticka podmienka: "+ conditionsSRG.checkAll_OneMatrix(6, q2) );
			System.out.println("Linearna podmienka: "+ conditionsSRG.checkAll_OneMatrix(6, lin) );
			
			if ((!conditionsSRG.checkNumber_of_OneMatrix(12, srg_matrix)) ||
				(!conditionsSRG.checkAll_OneMatrix(5, q1)) ||
				(!conditionsSRG.checkAll_OneMatrix(6, q2)) ||
				(!conditionsSRG.checkAll_OneMatrix(6, lin))){
				test = false;
			}
			else {pocet++;}
			System.out.println("VSETKY PODMIENKY: " + test);
			System.out.println("--------------------------");
			
			/*
			int[][] matica = new int[25][25];

			for(int j=1;j<13;j++) matica[0][j] = 1;
			for(int j=1;j<13;j++) matica[j][0] = 1;

			for(int j=1; j<13; j++){
				for(int k=1; k<13; k++){
					
					matica[j][k]= matrix_A[j-1][k-1];
				}
			}

			for(int j=13; j<25; j++){
				for(int k=13; k<25; k++){
					matica[j][k]= matrix_C[j-13][k-13];
				}
			}

			for(int j=13; j<25; j++){
				for(int k=1; k<13; k++){
					matica[j][k]= matrix_B[j-13][k-1];
				}
			}

			for(int j=1; j<13; j++){
				for(int k=13; k<25; k++){
					matica[j][k]= matrix_B[k-13][j-1];
				}
			}
			
			// VYPIS MATICE:
			for(int j=0;j<25;j++){
				for(int k=0;k<25;k++){
					System.out.print(matica[j][k]);
				}
				System.out.println();
			}
			
			
			System.out.println("------------------------------------------");
			*/
		}
		System.out.println("pocet: " + pocet);
		//DEBUG
//		int[][] a = {{1,1},{1,1}};
//		int[][] b = conditionsSRG.transposeMatrix(a);
//		int[][] c = conditionsSRG.multiply(a, b);
//		for(int i = 0; i< 2; i++){
//			for(int j =0 ; j< 2; j++){
//				System.out.print(c[i][j]);
//			}
//			System.out.println();
//		}
//		System.out.println(conditionsSRG.checkAll_OneMatrix(2, a));
//		System.out.println(conditionsSRG.checkNumber_of_OneMatrix(1, a));
	}

}
