import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;

import gurobi.GRB;
import gurobi.GRBEnv;
import gurobi.GRBException;
import gurobi.GRBLinExpr;
import gurobi.GRBModel;
import gurobi.GRBQuadExpr;
import gurobi.GRBVar;

public class Gurobi {

	public static void main(String[] args) throws Exception {
		
		long start = System.currentTimeMillis();
		Multiplication multiplication = new Multiplication();
		multiplication.getSolution();
		int number_solution = 0;
		ArrayList<int[][]> solution  = multiplication.solution_matrices_linear;
		ArrayList<int[][]> a1_matrices = multiplication.a1_matrices_fixed;
		ArrayList<int[][]> a2_matrices = multiplication.a2_matrices;
		ArrayList<int[]> equation_quadratic_1 = multiplication.equation_matrices_quadratic_1;
		ArrayList<int[]> equation_quadratic_2 = multiplication.equation_matrices_quadratic_2;
		
		System.out.println("start");
		
		PrintStream out = new PrintStream(new FileOutputStream("gap_Equation1_Linear.txt"));
		PrintStream out2 = new PrintStream(new FileOutputStream("gap_Equation2_Linear.txt"));
		PrintStream out3 = new PrintStream(new FileOutputStream("gap_Equation3_Linear.txt"));
		
		
		try {
		     
		      GRBLinExpr expr = new GRBLinExpr();
		      GRBQuadExpr exp = new GRBQuadExpr();
		      int rozne = 0;
		      
		      for(int i=0;i<solution.size();i++){
//		      int i=0;
		    	  GRBEnv    env   = new GRBEnv();
			      GRBModel  model = new GRBModel(env);
			      
			      model.getEnv().set(GRB.IntParam.SolutionLimit, 2);
			      // Create variables
			      GRBVar[] vars = model.addVars(144,GRB.BINARY);
			      
			      for(int j=0;j<vars.length;j++){
			    	  vars[j] = model.addVar(0.0, 1.0, 0.0, GRB.BINARY, "x_"+j);
			      }
			      
			      model.update();
			      
			      // LINEAR 
		    	  for(int j=0;j<144;j++){
		    		  
		    		  expr = new GRBLinExpr();
		    		  for(int k=0;k<144;k++){
		    			  expr.addTerm(solution.get(i)[j][k], vars[k]);
		    		  }
		    		  model.addConstr(expr, GRB.EQUAL, 6.0, "c_"+j);
		    	  }

//		    	  //QUADRATIC 1
//		    	  for(int k=0; k<12; k++){
//		    		  for(int l=0; l<12; l++){
//		   				  exp = new GRBQuadExpr();
//		   				  for(int m=0; m<12; m++){
//		   					  exp.addTerm(1.0,vars[k+12*m],vars[l+12*m]);
//	    				  }
//		   				  model.addQConstr(exp, GRB.EQUAL, multiplication.getSpecialQ1()[k][l], "qc1_"+k*12+l);
//		    			 }
//		    	  }
		    	   	
//		    	  //QUADRATIC 2
//		    	  for(int k=0; k<12; k++){
//		    		  for(int l=0; l<12; l++){
//		   				  exp = new GRBQuadExpr();
//		   				  for(int m=0; m<12; m++){
//		   					  exp.addTerm(1.0,vars[12*k+m],vars[12*l+m]);
//	    				  }
//		   				  model.addQConstr(exp, GRB.EQUAL, equation_quadratic_2.get(i)[k*12+l], "qc2_"+k*12+l);
//		    			 }
//		    	  }
		    	   
		    	  
		    	  model.optimize();
		    	  
		    	  if (model.get(GRB.IntAttr.Status) == GRB.OPTIMAL) {
		    		  System.out.println("OK");
		    	  }
		    	  
		    	  if (model.get(GRB.IntAttr.SolCount)!=0){
		    		  
		    		  
		    	  StringBuilder outputLine = new StringBuilder();
		    	   
		    	  outputLine.append("A := [");
		    	  for(int j=0;j<12;j++){
		    		  outputLine.append("[");
		    		  for(int k=0;k<12;k++){
		    			  outputLine.append(multiplication.a2_matrices.get(i)[j][k]);
		    			  if (k!=11) outputLine.append(",");
		    		  }
		    		  outputLine.append("]");
		    		  if (j!=11) outputLine.append(",");
		    	  }
		    	  outputLine.append("];; ");
		    	  
		    	  outputLine.append("B := [");
		    	  for(int j=0;j<12;j++){
		    		  outputLine.append("[");
		    		  for(int k=0;k<12;k++){
		    			  Double tmp = vars[j*12+k].get(GRB.DoubleAttr.X);
		    			
		    			  outputLine.append(tmp.intValue());
		    			  if (k!=11) outputLine.append(",");
		    		  }
		    		  outputLine.append("]");
		    		  if (j!=11) outputLine.append(",");
		    	  }
		    	  outputLine.append("];;");
		    	  
		    	  outputLine.append("A^2 + A - 6*IdentityMat(12,1) + TransposedMat(B)*B;");
		    	  
		    	  out.append(outputLine + "\n");
		    	  
		    	  
		    	  StringBuilder outputLine2 = new StringBuilder();
		    	  
		    	  outputLine2.append("C := [");
		    	  for(int j=0;j<12;j++){
		    		  outputLine2.append("[");
		    		  for(int k=0;k<12;k++){
		    			  outputLine2.append(multiplication.a2_matrices.get(i)[j][k]);
		    			  if (k!=11) outputLine2.append(",");
		    		  }
		    		  outputLine2.append("]");
		    		  if (j!=11) outputLine2.append(",");
		    	  }
		    	  outputLine2.append("];; ");
		    	  
		    	  outputLine2.append("B := [");
		    	  for(int j=0;j<12;j++){
		    		  outputLine2.append("[");
		    		  for(int k=0;k<12;k++){
		    			  Double tmp = vars[j*12+k].get(GRB.DoubleAttr.X);
		    			
		    			  outputLine2.append(tmp.intValue());
		    			  if (k!=11) outputLine2.append(",");
		    		  }
		    		  outputLine2.append("]");
		    		  if (j!=11) outputLine2.append(",");
		    	  }
		    	  outputLine2.append("];;");
		    	  
		    	  outputLine2.append("C^2 + C - 6*IdentityMat(12,1) + B*TransposedMat(B);");

		    	  out2.append(outputLine2 + "\n");
		    	  
		    	  StringBuilder outputLine3 = new StringBuilder();
		    	  
		    	  outputLine3.append("A := [");
		    	  for(int j=0;j<12;j++){
		    		  outputLine3.append("[");
		    		  for(int k=0;k<12;k++){
		    			  outputLine3.append(multiplication.getSpecialA1()[j][k]);
		    			  if (k!=11) outputLine3.append(",");
		    		  }
		    		  outputLine3.append("]");
		    		  if (j!=11) outputLine3.append(",");
		    	  }
		    	  outputLine3.append("];; ");
		    	  
		    	  outputLine3.append("C := [");
		    	  for(int j=0;j<12;j++){
		    		  outputLine3.append("[");
		    		  for(int k=0;k<12;k++){
		    			  outputLine3.append(multiplication.getSpecialA2()[j][k]);
		    			  if (k!=11) outputLine3.append(",");
		    		  }
		    		  outputLine3.append("]");
		    		  if (j!=11) outputLine3.append(",");
		    	  }
		    	  outputLine3.append("];; ");
		    	  
		    	  outputLine3.append("B := [");
		    	  for(int j=0;j<12;j++){
		    		  outputLine3.append("[");
		    		  for(int k=0;k<12;k++){
		    			  Double tmp = vars[j*12+k].get(GRB.DoubleAttr.X);
		    			
		    			  outputLine3.append(tmp.intValue());
		    			  if (k!=11) outputLine3.append(",");
		    		  }
		    		  outputLine3.append("]");
		    		  if (j!=11) outputLine3.append(",");
		    	  }
		    	  outputLine3.append("];;");
		    	  
		    	  outputLine3.append("B*A + C*B + B;");
		    	  out3.append(outputLine3 + "\n");
		    	  number_solution++;
		    	  }
		    	  
		    	  model.dispose();
			      env.dispose();
		      }
		   
		      out.close();
		      out2.close();
			  out3.close();
		      System.out.println("Finish");
		      System.out.println("Number: " + number_solution);
		      long end = System.currentTimeMillis();
			  System.out.println("Execution time was " + (end - start) + " ms.");
		      
		    } catch (GRBException e) {
		      System.out.println("Error code: " + e.getErrorCode() + ". " +
		                         e.getMessage());
		    }
		
	}

}
