import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;

public class Multiplication {

	public ArrayList<int[][]> a1_matrices;
	public ArrayList<int[][]> a2_matrices;
	public ArrayList<int[][]> solution_matrices_linear = new ArrayList<int[][]>();;
	public ArrayList<int[]> equation_matrices_quadratic_1 = new ArrayList<int[]>();
	public ArrayList<int[]> equation_matrices_quadratic_2 = new ArrayList<int[]>();
	public ArrayList<int[][]> a1_matrices_fixed = new ArrayList<int[][]>();

	public ArrayList<Integer> number_a2_matrices = new ArrayList<Integer>();

	public int[][] getSpecialQ1() {
		int[][] q1_matrix = { { 6, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 },
				{ 0, 6, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 },
				{ 3, 3, 6, 2, 2, 2, 2, 2, 2, 4, 4, 4 },
				{ 3, 3, 2, 6, 2, 2, 3, 3, 4, 2, 3, 3 },
				{ 3, 3, 2, 2, 6, 2, 3, 4, 3, 3, 2, 3 },
				{ 3, 3, 2, 2, 2, 6, 4, 3, 3, 3, 3, 2 },
				{ 3, 3, 2, 3, 3, 4, 6, 2, 2, 3, 2, 3 },
				{ 3, 3, 2, 3, 4, 3, 2, 6, 2, 2, 4, 2 },
				{ 3, 3, 2, 4, 3, 3, 2, 2, 6, 3, 2, 3 },
				{ 3, 3, 4, 2, 3, 3, 3, 2, 3, 6, 2, 2 },
				{ 3, 3, 4, 3, 2, 3, 2, 4, 2, 2, 6, 2 },
				{ 3, 3, 4, 3, 3, 2, 3, 2, 3, 2, 2, 6 } };
		return q1_matrix;
	}

	public int[][] getSpecialQ2() {
		int[][] q2_matrix = { { 6, 3, 4, 3, 2, 3, 3, 3, 2, 2, 3, 2 },
				{ 3, 6, 3, 3, 3, 3, 2, 3, 4, 3, 1, 2 },
				{ 4, 3, 6, 2, 3, 3, 3, 2, 3, 2, 2, 3 },
				{ 3, 3, 2, 6, 4, 3, 3, 3, 1, 3, 2, 3 },
				{ 2, 3, 3, 4, 6, 3, 3, 1, 3, 3, 3, 2 },
				{ 3, 3, 3, 3, 3, 6, 1, 3, 2, 2, 4, 3 },
				{ 3, 2, 3, 3, 3, 1, 6, 4, 3, 3, 3, 2 },
				{ 3, 3, 2, 3, 1, 3, 4, 6, 3, 2, 3, 3 },
				{ 2, 4, 3, 1, 3, 2, 3, 3, 6, 3, 3, 3 },
				{ 2, 3, 2, 3, 3, 2, 3, 2, 3, 6, 3, 4 },
				{ 3, 1, 2, 2, 3, 4, 3, 3, 3, 3, 6, 3 },
				{ 2, 2, 3, 3, 2, 3, 2, 3, 3, 4, 3, 6 } };
		return q2_matrix;
	}

	public int[][] getSpecialA1() {
		int[][] a1_matrix = { { 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0 },
				{ 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0 },
				{ 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0 },
				{ 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0 },
				{ 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1 },
				{ 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1 },
				{ 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0 },
				{ 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0 },
				{ 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 1 },
				{ 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 1, 1 },
				{ 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1 },
				{ 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0 } };
		return a1_matrix;
	}

	public int[][] getSpecialA2() {
		int[][] a2_matrix = { { 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1 },
				{ 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 0 },
				{ 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1 },
				{ 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1 },
				{ 1, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0 },
				{ 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0 },
				{ 0, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 0 },
				{ 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0 },
				{ 1, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1 },
				{ 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1 },
				{ 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1 },
				{ 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0 } };
		return a2_matrix;
	}

	public int[][] getSpecialSolution() {
		int number = 12;
		int[][] solution = new int[number * number][number * number];
		int[][] a1_matrix = { { 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0 },
				{ 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0 },
				{ 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0 },
				{ 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0 },
				{ 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1 },
				{ 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1 },
				{ 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0 },
				{ 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0 },
				{ 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 1 },
				{ 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 1, 1 },
				{ 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1 },
				{ 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0 } };

		// SRG MATRIX
		int[][] a2_matrix = { { 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1 },
				{ 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 0 },
				{ 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1 },
				{ 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1 },
				{ 1, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0 },
				{ 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0 },
				{ 0, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 0 },
				{ 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0 },
				{ 1, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1 },
				{ 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1 },
				{ 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1 },
				{ 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0 } };
		
		int[][] a2_matrix_changed = new int[number][number];

		for (int j = 0; j < number; j++) {
			for (int k = 0; k < number; k++) {

				a2_matrix_changed[j][k] = a2_matrix[j][k];
				if (j == k)
					a2_matrix_changed[j][k] = a2_matrix[j][k] + 1;

			}
		}

		for (int j = 0; j < number; j++) {
			for (int k = 0; k < number; k++) {

				for (int l = 0; l < number; l++)
					solution[j * number + k][j * number + l] += a1_matrix[l][k];

				for (int l = 0; l < number; l++)
					solution[j * number + k][l * number + k] += a2_matrix_changed[j][l];

			}
		}

		return solution;
	}

	public void getSolution() throws Exception {

		a2_matrices = new ArrayList<int[][]>();
		PrintStream out = new PrintStream(new FileOutputStream(
				"gap_equation_quadratic1.txt"));
		PrintStream out2 = new PrintStream(new FileOutputStream(
				"gap_equation_quadratic2.txt"));

		BufferedReader in_q_1 = new BufferedReader(new FileReader(
				"equation_quadratic1.txt"));
		BufferedReader in_q_2 = new BufferedReader(new FileReader(
				"equation_quadratic2.txt"));

		String line;
		while ((line = in_q_1.readLine()) != null) {
			int[] mat = new int[144];
			line = line.replaceAll("\\[", "");
			line = line.replaceAll("\\]", "");
			String tmp[] = line.split(",");
			for (int i = 0; i < tmp.length; i++) {
				mat[i] = Integer.parseInt(tmp[i].trim());

			}
			equation_matrices_quadratic_1.add(mat);

		}

		while ((line = in_q_2.readLine()) != null) {
			int[] mat = new int[144];
			line = line.replaceAll("\\[", "");
			line = line.replaceAll("\\]", "");
			String tmp[] = line.split(",");
			for (int i = 0; i < tmp.length; i++) {
				mat[i] = Integer.parseInt(tmp[i].trim());
			}
			equation_matrices_quadratic_2.add(mat);
		}

		ParseASCFormat parseASCFormat = new ParseASCFormat();
		parseASCFormat.ParseASC("12_5_3.asc");
		a1_matrices = parseASCFormat.getMatrixGraphs();

		ParseASCFormat parseASCFormat2 = new ParseASCFormat();
		parseASCFormat2.ParseASC("12_6_3.asc");
		ArrayList<int[][]> reg6_matrices = parseASCFormat2.getMatrixGraphs();

		// characteristic polynomial without root
		BufferedReader in1 = new BufferedReader(new FileReader("opravene2.out"));
		ArrayList<String> charPolynom_complement_12_5 = new ArrayList<String>();

		BufferedReader in2 = new BufferedReader(new FileReader("12_6_3-characPolynomial.out"));
		ArrayList<String> charPolynom_12_6 = new ArrayList<String>();

		while ((line = in1.readLine()) != null)
			charPolynom_complement_12_5.add(line);
		while ((line = in2.readLine()) != null)
			charPolynom_12_6.add(line);

		for (int i = 0; i < a1_matrices.size(); i++) {
			int[][] solutionMatrix = new int[144][144];
			int[][] a2_matrix_changed = new int[12][12];

			// null solutionMatrix
			for (int j = 0; j < 144; j++) {
				for (int k = 0; k < 144; k++)
					solutionMatrix[j][k] = 0;
			}

			// finding matrix A2
			ArrayList<int[][]> tmpA2_matrices = new ArrayList<int[][]>();
			for (int j = 0; j < charPolynom_12_6.size(); j++) {
				if (charPolynom_complement_12_5.get(i).equals(
						charPolynom_12_6.get(j))) {
					a2_matrices.add(reg6_matrices.get(j));
					tmpA2_matrices.add(reg6_matrices.get(j));
				}
			}
			number_a2_matrices.add(tmpA2_matrices.size());

			// SOLUTION LINEAR EQUATION BEGIN
			for (int z = 0; z < tmpA2_matrices.size(); z++) {

				// added on diagonal in matrix a2
				for (int j = 0; j < 12; j++) {
					for (int k = 0; k < 12; k++) {

						a2_matrix_changed[j][k] = tmpA2_matrices.get(z)[j][k];
						if (j == k)
							a2_matrix_changed[j][k] = tmpA2_matrices.get(z)[j][k] + 1;

					}
				}

				int number = 12;
				for (int j = 0; j < number; j++) {
					for (int k = 0; k < number; k++) {

						for (int l = 0; l < number; l++)
							solutionMatrix[j * number + k][j * number + l] += a1_matrices
									.get(i)[l][k];

						for (int l = 0; l < number; l++)
							solutionMatrix[j * number + k][l * 12 + k] += a2_matrix_changed[j][l];

					}
				}

				solution_matrices_linear.add(solutionMatrix);
				a1_matrices_fixed.add(a1_matrices.get(i));
			}
			// SOLUTION LINEAR EQUATION END
			/*
			 * //SOLUTION 1.QUADRATIC EQUATION BEGIN
			 * 
			 * for(int z=0;z<tmpA2_matrices.size();z++){ StringBuilder
			 * outputLine = new StringBuilder();
			 * 
			 * //matrix A1 outputLine.append("A := ["); for(int j=0;j<12;j++){
			 * outputLine.append("["); for(int k=0;k<12;k++){
			 * outputLine.append(a1_matrices.get(i)[j][k]); if (k!=11)
			 * outputLine.append(","); } outputLine.append("]"); if (j!=11)
			 * outputLine.append(","); } outputLine.append("];; ");
			 * 
			 * //Identity matrix outputLine.append("J := ["); for(int
			 * j=0;j<12;j++){ outputLine.append("["); for(int k=0;k<12;k++){
			 * outputLine.append("1"); if (k!=11) outputLine.append(","); }
			 * outputLine.append("]"); if (j!=11) outputLine.append(","); }
			 * 
			 * outputLine.append("];; ");
			 * 
			 * outputLine.append("5*J-A^2-A+6*IdentityMat(12,1);");
			 * out.append(outputLine + "\n"); }
			 * 
			 * //SOLUTION 1.QUADRATIC EQUATION END
			 * 
			 * 
			 * //SOLUTION 2.QUADRATIC EQUATION BEGIN for(int
			 * z=0;z<tmpA2_matrices.size();z++){
			 * 
			 * StringBuilder outputLine2 = new StringBuilder(); //Matrix A2
			 * outputLine2.append("C := ["); for(int j=0;j<12;j++){
			 * outputLine2.append("["); for(int k=0;k<12;k++){
			 * outputLine2.append(tmpA2_matrices.get(z)[j][k]); if (k!=11)
			 * outputLine2.append(","); } outputLine2.append("]"); if (j!=11)
			 * outputLine2.append(","); } outputLine2.append("];; ");
			 * 
			 * //Identity matrix outputLine2.append("J := ["); for(int
			 * j=0;j<12;j++){ outputLine2.append("["); for(int k=0;k<12;k++){
			 * outputLine2.append("1"); if (k!=11) outputLine2.append(","); }
			 * outputLine2.append("]"); if (j!=11) outputLine2.append(","); }
			 * 
			 * outputLine2.append("];; ");
			 * 
			 * outputLine2.append("6*J-C^2-C+6*IdentityMat(12,1);");
			 * out2.append(outputLine2 + "\n"); }
			 * 
			 * //SOLUTION 2.QUADRATIC EQUATION END
			 */
		}
		out.close();
		out2.close();
	}

	public static void main(String[] args) throws Exception {
		long start = System.currentTimeMillis();
		Multiplication multiplication = new Multiplication();
		multiplication.getSolution();

		int sum = 0;
		for (int i = 0; i < multiplication.number_a2_matrices.size(); i++) {
			sum += multiplication.number_a2_matrices.get(i);
		}
		System.out.println(sum);

		int tmp = 0;
		int n = 0;
		while (sum != tmp) {
			int s = 0;
			for (int i = 0; i < multiplication.number_a2_matrices.size(); i++) {
				if (multiplication.number_a2_matrices.get(i) == n)
					s++;
			}
			if (s != 0)
				System.out.println("Number of " + n + " is: " + s);
			tmp += n * s;
			n++;
		}
		long end = System.currentTimeMillis();
		System.out.println("Execution time was " + (end - start) + " ms.");
		System.out.println("Done!");
	}

}
