#ifndef BLOCK_FILE

#define BLOCK_FILE
#include <unistd.h>
#include <errno.h>
#include <cassert>
#include <string.h>
#include <stdexcept>
#define BLOCK_SIZE 512
#define MEMORY_BLOCKS 2
#define MEMORY_ITEMS (MEMORY_BLOCKS * BLOCK_SIZE / sizeof(int))

namespace boost {

  class block_file {
    
  private:
    FILE *file;
    char access, *fname;
    int del_mode;
    
  public:
    char buffer[BLOCK_SIZE];
    int buf_pos;

 		block_file() : fname(0) { }
     
    block_file(char* name, char* mode, int del=2) : access(mode[0]), del_mode(del) {
      // we need to store a local copy of the name that will be eventually used when deleting the file
      fname = new char[strlen(name)+sizeof(char)];
      strcpy(fname, name);
 		  
      // try to open the file
      file = fopen(fname, mode); //fprintf(stderr, "open %s for %s\n", fname, mode);
 		  if (!file) throw std::runtime_error("error opening");
 		  
      if (mode[0]=='w') buf_pos = 0; else 
 		  if (mode[0]=='r') buf_pos = -1;      // force buffer read on next load_block() call
 		}
     
    void load_block(int block, int count, void *b) {
      fseek(file, block - block % BLOCK_SIZE, SEEK_SET);  // seek to the beginning of the block corresponding to the given offset
      int number = fread(b, 1, count * BLOCK_SIZE, file);
      for (int i=number; i<BLOCK_SIZE*count; i++) ((char *) b)[i] = 0;  // fill missing numbers with 0's
    }
    
    void load_block(int block) {
		  int new_pos = block - block % BLOCK_SIZE;   // calculate the block corresponding to the given offset
		  
      // read the requested block only if it is not already in the memory
      if (new_pos != buf_pos) {
        buf_pos = new_pos;
        load_block(buf_pos, 1, (void *) buffer);
		  }
		}
    
    void write_block(int block, int count, void *b) {
      fseek(file, block - block % BLOCK_SIZE, SEEK_SET);    // seek to the beginning of the block corresponding to the given offset
      int number = fwrite(b, 1, count * BLOCK_SIZE, file); 
      if (number != count * BLOCK_SIZE) {                   // treat failure to write all items as error
        throw std::runtime_error("error writing");
      }
    }
    
    void write_block() {
      write_block(buf_pos, 1, (void *) buffer);
		}
		
		~block_file() {
	    if (file) { fclose(file); /*fprintf(stderr, "close %s\n", fname);*/ }      // close file associated to this object
		  if (fname && (del_mode==1 || del_mode==2 && access == 'w')) unlink(fname); // delete underlying file if requested by user
		  if (fname) delete fname;                                                   // free memory occupied by file name
		}

  };

}
#endif
