#include <boost/concept_check.hpp>
#include "external_sequence.hpp"
#include "external_graph.hpp"
#include "external_mergesort.hpp"

namespace boost {
  
  typedef remove_duplicates<list_sequence> duplicates_sequence;
  typedef unify_sequence<list_sequence, list_sequence> t2_sequence;
  typedef complement_sequence<duplicates_sequence, t2_sequence> t1_sequence;

  template <class EBFSVisitor>
  class EBFSVisitorConcept {
    public:
      void constraints() {
        visitor.visit(vertex, component, level);
      }
    private:
      EBFSVisitor visitor;
      int vertex, component, level;
  };

  template <class EGraph, class EBFSVisitor>
  void external_breadth_first_search(EGraph &g, EBFSVisitor &visitor, int u) {
    function_requires<EBFSVisitorConcept<EBFSVisitor> >();
    function_requires<EGraphConcept<EGraph> >();
  
    list_sequence *front_1 = new list_sequence(u), *front_2 = new list_sequence(), *front_3 = new list_sequence();
    int t = 0;
    
    visitor.visit(u, u, 0);
    while (!front_1->empty()) {
      // create nbr(front(t-1)) by concatenating neighbours lists
      list_sequence nbr = list_sequence("nbr.tmp");
      front_1->init_iterator();
      while (front_1->has_next()) {
        int v = front_1->get_next();
        g.init_iterator(v);
        while (g.has_next()) {
          int t = g.get_next();
          nbr.add(t);
        }
      }
      
      // shift pointers to front sequences
      delete front_3;
      front_3 = front_2; front_2 = front_1;
      
      // sort nbr sequence
      nbr.flush(); nbr.f = external_mergesort(nbr.f, nbr.count/sizeof(int));

      // create new front sequence
      duplicates_sequence nbr_duplicates(&nbr);
      t2_sequence t2(front_2, front_3);
      t1_sequence t1(&nbr_duplicates, &t2);

      // store front(t) sequence as list_sequence
      t1.init_iterator();
      char name[100];
      sprintf(name, "front.%d.tmp", t);
      front_1 = new list_sequence(name);
      while (t1.has_next()) {
        int v = t1.get_next();
        visitor.visit(v, u, t+1);
        front_1->add(v);
      }
      front_1->flush();
      t++;
    }
    delete front_1; delete front_2; delete front_3;
  }
  
  template <class EBFSVisitor>
  class bft_visitor {
  
  private:
    EBFSVisitor &visitor;
    bit_sequence &unvisited;
    
  public:
    bft_visitor(EBFSVisitor &v, bit_sequence &u) : visitor(v), unvisited(u) {
      function_requires<EBFSVisitorConcept<EBFSVisitor> >();
    }
    
    void visit(int vertex, int component, int level) {
      unvisited.remove(vertex);
      visitor.visit(vertex, component, level);
    }
    
  };
  
  template <class EGraph, class EBFSVisitor>
  void external_breadth_first_traversal(EGraph &g, EBFSVisitor &visitor) {
    function_requires<EBFSVisitorConcept<EBFSVisitor> >();
    function_requires<EGraphConcept<EGraph> >();
  
    bit_sequence unvisited("unvisited.tmp", num_vertices(g));
    bft_visitor<EBFSVisitor> vis(visitor, unvisited);
    
    // call external_breadth_first_search for the first unvisted vertex until no more such vertices exists
    while (unvisited.init_iterator(), unvisited.has_next()) external_breadth_first_search(g, vis, unvisited.get_next());
  }

}
