#include <utility>
#include <math.h>
#include "block_file.hpp"

namespace boost {

  template <class SearchStructure>
  class SearchStructureConcept {
    public:
      void constraints() {
        b = ss.count(n);
      }
    private:
      SearchStructure ss;
      int n;
      bool b;
  };

  template <class EGraph>
  class EGraphConcept {
    public:
      void constraints() {
        g.init_iterator(vertex);
        b = g.has_next();
        vertex = g.get_next();
        vertex = num_vertices(g);
      }
    private:
      EGraph g;
      int vertex;
      bool b;
  };

  template <class EGraph, class SearchStructure>
  class MultiRemoveEGraphConcept {
    public:
      void constraints() {
        g.remove_visited(ss);
      }
    private:
      EGraph g;
      SearchStructure ss;
  };

	typedef int vertex_descriptor;

	class external_graph {

  friend int num_vertices(external_graph& g);
    
  private:
    int index_start, lists_start;           // blok so zaciatkom indexu, blok so zaciatkom zoznamov
    int num_vert;
    block_file* f;
    int iter_pos, iter_end;

    // returns offset to the beginning of the neighbour list for vertex v
    int get_pos(vertex_descriptor v) {
      if (v==0) return lists_start*BLOCK_SIZE; 
      int index = v-1;
		  int new_pos = (index*sizeof(vertex_descriptor) / BLOCK_SIZE + index_start) * BLOCK_SIZE;
      f->load_block(new_pos);
      return ((int*) f->buffer)[index % (BLOCK_SIZE / sizeof(vertex_descriptor))];
		}

    // skip in the current neighbour list to the next vertex that is not removed
    void skip() {
      while (iter_pos < iter_end && get_current() == -1) iter_pos += sizeof(vertex_descriptor);
    }

  public:
    external_graph() { }
    
    external_graph(char* file) {
		  f = new block_file(file, "r+");
		  
		  if (f) {
		    f->load_block(0);
  		  num_vert = ((int*) f->buffer)[0];
  		  index_start = 1;
        lists_start = index_start + (int) ceil(((double) num_vert)*sizeof(int)/BLOCK_SIZE);
  		}
		}
		
		template <class SearchStructure>
		void remove_visited(SearchStructure &ss) {
  		function_requires<SearchStructureConcept<SearchStructure> >();

		  // iterate through all blocks that belong to an adjacency list, removing visited vertices 
		  int start_pos = get_pos(0);
		  int end_pos = get_pos(num_vert);
		  int *vert_buffer = (int *) f->buffer;
		  for (int i=start_pos; i<end_pos; i++) {
		    f->load_block(i);
		    if (ss.count(vert_buffer[(i % BLOCK_SIZE) / sizeof(int)])) {
          vert_buffer[(i % BLOCK_SIZE) / sizeof(int)] = -1;
        }
		    if ((i + sizeof(vertex_descriptor)) / BLOCK_SIZE > i / BLOCK_SIZE) f->write_block();
		  }
		  f->write_block();
		}

    void set_position(int current, int end) {
      iter_pos = current; iter_end = end;
    }
    
    std::pair<int, int> get_position() {
      return std::make_pair(iter_pos, iter_end);
    }
    
		vertex_descriptor get_current() {
		  f->load_block(iter_pos);
		  return ((int*) f->buffer)[(iter_pos % BLOCK_SIZE) / sizeof(int)];
		}
		
		bool has_next() {
		  return iter_pos < iter_end;
		}
		
		int get_next() {
		  f->load_block(iter_pos);
		  vertex_descriptor result = ((int*) f->buffer)[(iter_pos % BLOCK_SIZE) / sizeof(int)];
      iter_pos += sizeof(vertex_descriptor); skip();
      return result;
    }		

    std::pair<int, int> init_iterator(vertex_descriptor v) {
			iter_pos = get_pos(v);
			iter_end = get_pos(v+1);
			skip();
			return std::make_pair(iter_pos, iter_end);
		}
		
	};

	int num_vertices(external_graph& g) {
	  return g.num_vert;
	}
  
}
