#include <stdio.h>
#include <utility>
#include <math.h>

namespace boost {

	class external_stack {

  private:
    int *item_buffer;
    int top;
    block_file* f;
    
  public:
    external_stack(char* file = "stack.000.tmp") : top(-1) {
      f = new block_file(file, "w+");
      item_buffer = (int *) f->buffer;
    }
    
    void push(int item) {
      if (top >= 0 && top / (BLOCK_SIZE / sizeof(int)) != (top+1) / (BLOCK_SIZE / sizeof(int))) {
        f->write_block();
        f->buf_pos += BLOCK_SIZE;
      }
      top++;
      item_buffer[top % (BLOCK_SIZE / sizeof(int))] = item;
    }
    
    int pop() {
      int result = item_buffer[top % (BLOCK_SIZE / sizeof(int))];
      top--;
      if (top >= 0 && top / (BLOCK_SIZE / sizeof(int)) != (top+1) / (BLOCK_SIZE / sizeof(int))) {
        f->write_block();
        f->load_block(f->buf_pos - BLOCK_SIZE);
      }
      return result;
    }
    
    int get_top() {
      return item_buffer[top % (BLOCK_SIZE / sizeof(int))];
    }
    
    bool empty() {
      return top <= -1;
    }
    
  };
  
}
