/*
 * Decompiled with CFR 0.152.
 */
package com.libfsm.automata.machines;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.libfsm.automata.helpers.Pair;
import com.libfsm.automata.helpers.Sets;
import com.libfsm.automata.helpers.Triple;
import com.libfsm.automata.machines.DFA;
import com.libfsm.automata.machines.FSMType;
import com.libfsm.automata.machines.NFA;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class FSM {
    public static final Character EPSILON = Character.valueOf('$');
    protected FSMType fsmType;
    protected Set<Character> alphabet = new HashSet<Character>();
    protected Set<String> states = new HashSet<String>();
    protected Set<String> finalStates = new HashSet<String>();
    protected String initial = "";
    protected String name;

    public FSM(String name) {
        this.name = name;
    }

    public abstract void addState(String var1);

    public abstract void removeState(String var1);

    public abstract void renameState(String var1, String var2);

    public abstract void addTransition(String var1, Character var2, String var3);

    public abstract void removeTransition(String var1, Character var2, String var3);

    public abstract Set<Character> getAllTransitionsFromTo(String var1, String var2);

    public abstract Triple<Set<String>, Boolean, Integer> compute(String var1, boolean var2);

    public abstract Set<String> computeStep(Set<String> var1, Character var2);

    public abstract Set<String> epsilonClosure(Set<String> var1);

    public abstract boolean isCorrectlyDefined();

    public abstract void setAlphabet(Set<Character> var1);

    public abstract void writeToFile(File var1);

    public abstract String notCorrectlyDefinedText();

    public abstract Map<Pair<String, Character>, Set<String>> getEpsilonTransitions();

    public abstract Set<Pair<Character, String>> getAllTransitionsFrom(String var1);

    public void addStateFinal(String state) {
        this.finalStates.add(state);
    }

    public void removeStateFinal(String state) {
        this.finalStates.remove(state);
    }

    public void setFsmType(FSMType fsmType) {
        this.fsmType = fsmType;
    }

    public FSMType getFsmType() {
        return this.fsmType;
    }

    public abstract Map<Pair<String, Character>, Set<String>> getTransitions();

    public Set<String> getStates() {
        return this.states;
    }

    public Set<String> getFinalStates() {
        return this.finalStates;
    }

    public boolean isFinalState(String state) {
        return this.finalStates.contains(state);
    }

    public Set<Character> getAlphabet() {
        return this.alphabet;
    }

    public String getInitial() {
        return this.initial;
    }

    public void setInitial(String state) {
        this.initial = state;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static boolean disjointStates(FSM first, FSM second) {
        return Sets.intersection(first.getStates(), second.getStates()).isEmpty();
    }

    public abstract FSM copy();

    public static FSM readFromFile(File file) {
        JsonParser parser = new JsonParser();
        FSM machine = new NFA("imported");
        try (FileReader reader = new FileReader(file);){
            JsonElement rootElement = parser.parse((Reader)reader);
            JsonObject rootObject = rootElement.getAsJsonObject();
            JsonPrimitive typePrimitive = rootObject.getAsJsonPrimitive("type");
            String type = typePrimitive.getAsString();
            JsonArray alphArray = rootObject.getAsJsonArray("alphabet");
            HashSet<Character> alph = new HashSet<Character>();
            alphArray.forEach(e -> alph.add(Character.valueOf(e.getAsCharacter())));
            JsonArray statesArray = rootObject.getAsJsonArray("states");
            HashSet states = new HashSet();
            statesArray.forEach(e -> states.add(e.getAsString()));
            JsonArray transitionsArray = rootObject.getAsJsonArray("transitions");
            HashSet transitions = new HashSet();
            transitionsArray.forEach(e -> {
                JsonObject obj = e.getAsJsonObject();
                transitions.add(new Triple<String, Character, String>(obj.getAsJsonPrimitive("source").getAsString(), Character.valueOf(obj.getAsJsonPrimitive("symbol").getAsCharacter()), obj.getAsJsonPrimitive("destination").getAsString()));
            });
            JsonPrimitive initialPrimitive = rootObject.getAsJsonPrimitive("initial");
            String initialState = initialPrimitive.getAsString();
            JsonArray finalStatesArray = rootObject.getAsJsonArray("final_states");
            HashSet finalStates = new HashSet();
            finalStatesArray.forEach(e -> finalStates.add(e.getAsString()));
            machine = type.equals("DFA") ? new DFA("importedDFA") : new NFA("importedNFA");
            machine.setAlphabet(alph);
            states.forEach(machine::addState);
            for (Triple t : transitions) {
                machine.addTransition((String)t.getFirst(), (Character)t.getSecond(), (String)t.getThird());
            }
            machine.setInitial(initialState);
            finalStates.forEach(machine::addStateFinal);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return machine;
    }
}

