package bridge;

import java.io.InputStream; 
import java.io.OutputStream; 
import java.net.Socket;

public class ConnectionInvitation {
    public static final int CONNECTION_FOR_TRANSFER = 1;
    public static final int CONNECTION_FOR_COMMUNICATION = 2;
    
    
    private Socket socket;
    
    private InputStream inputStream;

    private OutputStream outputStream;

    private int connectionType;

    private String foreignID;

    public ConnectionInvitation (Socket s,InputStream is,OutputStream os,int conType,String forID) {
        this.socket = s;
        this.inputStream = is;
        this.outputStream = os;
        this.connectionType = conType;
        this.foreignID = forID;
    }

    public int getConnectionType () {
        return connectionType;
    }


    public String getForeignID () {
        return foreignID;
    }

    public InputStream getInputStream () {
        return inputStream;
    }

    public OutputStream getOutputStream () {
        return outputStream;
    }

    public Socket getSocket() {
        return socket;
    }
}

