package client;

import client.net.commun.ClientManager;
import client.net.transfer.TransferManager;
import client.net.lan.LANManager;
import client.gui.MainFrame;
import client.net.ClientConnectionWaiter;
import client.net.ConnectionProvider;
import client.net.SSLConnector;
import client.net.transfer.BasicTransferMngATPCProvider;
import common.Toolkit;
import common.commun.TrafficHandler;
import exceptions.MyException;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.xml.parsers.ParserConfigurationException;

//cert passwd: turtlepassword
//alias      : turtlestandard
public class MainClass {

    public static final String CLIENT_VERSION = "1.0";
    public static final String USER_HOME_DIR = System.getProperty("user.home") + File.separator + "Turtle";
    public static final String SCRIPTS_DIR = System.getProperty("user.dir") + File.separator + "clientscripts";
    private static String dbDir = MainClass.USER_HOME_DIR + File.separator + "TurtleDB";
    private static String dbSrciptFile = MainClass.SCRIPTS_DIR + File.separator + "clientDBscript.txt";
    private ShareManager mFileShareManager;
    private MainFrame mMainFrame;
    private ClientManager mClientManager;
    private TransferManager mTransferManager;
    private LANManager lanManager;
    private TrafficHandler trafficHandler;
    private ClientConnectionWaiter connectionWaiter;
    private Connection con;
    private ConnectionProvider connector;

    public MainClass() throws MyException, SQLException, ParserConfigurationException, IOException, ClassNotFoundException, Exception {
        initClientDir();
        initConnection();

        OptionalValueProvider.loadValues();
        mFileShareManager = new ShareManager(con);
        OwnFileDescriptor.setConnection(con);
        connector = new SSLConnector();
        trafficHandler = new TrafficHandler();
        mClientManager = new ClientManager(mFileShareManager, connector,trafficHandler);
        mTransferManager = new TransferManager(mFileShareManager, new BasicTransferMngATPCProvider(), connector);
        trafficHandler.registerConnectionHandler(mClientManager);
        trafficHandler.registerConnectionHandler(mTransferManager);
        connectionWaiter = new ClientConnectionWaiter(trafficHandler, OptionalValueProvider.getCommunicationListeningPort());
        
        lanManager = new LANManager(OptionalValueProvider.getBroadcastPort());
    //lanManager = new LANManager(4900);
    }

    private void initClientDir() {
        File f = new File(USER_HOME_DIR);
        if (!f.exists()) {
            f.mkdir();
        }

        f = new File(dbDir);
        if (!f.exists()) {
            f.mkdir();
        }
    }

    private void initConnection() throws MyException, SQLException, IOException, ClassNotFoundException {
        if (MainFrame.EMBEDDED_DB) {
            try {
                System.setProperty("derby.system.home", dbDir);
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
                con = DriverManager.getConnection("jdbc:derby:turtleDB;bootPassword=passtodb;");
            } catch (SQLException ex) {
                ex.printStackTrace();
                if (ex.getSQLState().equals("XJ004")) {
                    createDB();
                } else {
                    throw ex;
                }
            }
        } else {
            Class.forName("org.apache.derby.jdbc.ClientDriver");
            con = DriverManager.getConnection("jdbc:derby://localhost:1527/TurtleClientDB", "ati", "taoteking");
        }

    }

    private void createDB() throws SQLException, IOException {
        System.out.println("creating db");
        con = DriverManager.getConnection("jdbc:derby:turtleDB;create=true;dataEncryption=true;bootPassword=passtodb;");
        Toolkit.executeSQLFromFile(dbSrciptFile, con);
    }

    public ShareManager getSharingManager() {
        return mFileShareManager;
    }

    public void setSharingManager(ShareManager val) {
        this.mFileShareManager = val;
    }

    public MainFrame getMainFrame() {
        return mMainFrame;
    }

    public void setMainFrame(MainFrame val) {
        this.mMainFrame = val;
    }

    public ClientManager getClientManager() {
        return mClientManager;
    }

    public void setClientManager(ClientManager val) {
        this.mClientManager = val;
    }

    public TransferManager getTransferManager() {
        return mTransferManager;
    }

    public void setTransferManager(TransferManager val) {
        this.mTransferManager = val;
    }

    public LANManager getLanManager() {
        return lanManager;
    }
}
