/*
 * OptionalValueProvider.java
 *
 * Created on 23 April 2007, 14:16
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package client;

import common.XmlSpecChConv;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 *
 * @author A
 */
public class OptionalValueProvider {
    public static final String PROFILE_FILE_PATH = MainClass.USER_HOME_DIR + File.separator + "profile.xml";
    public static final String OPTION_FILE_PATH = MainClass.USER_HOME_DIR + File.separator + "options.xml";
    public static final String DEFAULT_DOWNLOAD_DIR = MainClass.USER_HOME_DIR + File.separator + "downloads" + File.separator;
    
    
    public static final int DEFAULT_COMMUNICATION_PORT = 4700;
    public static final String DEFAULT_NAME = "unnamed";
    public static final String DEFAULT_PASSWORD = "";
    public static final String DEFAULT_DESCRIPTION = "";
    public static final boolean DEFAULT_PASSIVE = true;
    public static final int DEFAULT_BROADCAST_PORT = 4950;
    
    private static int comListenPortToSave = DEFAULT_COMMUNICATION_PORT;
    private static int broadcastPortToSave = DEFAULT_BROADCAST_PORT;
    
    private static int comListeningPort = DEFAULT_COMMUNICATION_PORT;
    private static int broadcastPort = DEFAULT_BROADCAST_PORT;
    
    private static Profile profile = new Profile(DEFAULT_NAME,DEFAULT_PASSWORD);
    protected static String description = DEFAULT_DESCRIPTION;
    private static boolean passive = DEFAULT_PASSIVE;
    private static String downloadDir = DEFAULT_DOWNLOAD_DIR;
    
    private static String clientID = null;
    
    public static void loadValues() {
        loadProfile(PROFILE_FILE_PATH);
        loadOptionValues(OPTION_FILE_PATH);
        
        File f = new File(downloadDir);
        if (!f.exists()) f.mkdirs();
    }
    
    public static void writeProfile() {
        writeProfile(new File(PROFILE_FILE_PATH));
    }
    
    public static void writeProfile(File f){
        //   System.out.println("writing profile file");
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(f);
            
        } catch (FileNotFoundException ex) {
            try {
                f.createNewFile();
                pw = new PrintWriter(f);
            } catch (IOException e) {
                ex.printStackTrace();
            }
            
        }
        
        String profString = "<profile>\n" +
                "<name>"+ XmlSpecChConv.convert(profile.getName()) + "</name>\n"+
                "<desc>" + XmlSpecChConv.convert(profile.getDescription()) + "</desc>\n" +
                "</profile>";
        
        pw.println(profString);
        pw.flush();
        pw.close();
    }
    
    public static void loadProfile(String path) {
        File f = new File(path);
        try {
            if (!f.exists()) {
                writeProfile(f);
                
            } else {
                
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = docBuilder.parse(new InputSource(new FileReader(f)));
                Element root = doc.getDocumentElement();
                
                NodeList nl = root.getElementsByTagName("name");
                profile.setName(nl.item(0).getTextContent());
                
                nl = root.getElementsByTagName("desc");
                String desc = nl.item(0).getTextContent();
                profile.setDescription(desc);
            }
            
        } catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        } catch (SAXException ex) {
            ex.printStackTrace();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
        
    }
    
    public static void writeOptionValues() {
        writeOptionValues(new File(OPTION_FILE_PATH));
    }
    
    public static void writeOptionValues(File f)  {
        
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(f);
            
        } catch (FileNotFoundException ex) {
            try {
                f.createNewFile();
                pw = new PrintWriter(f);
            } catch (IOException e) {
                ex.printStackTrace();
            }
            
        }
        
        String optionString = "<options>\n" +
                "<communport>" + comListenPortToSave + "</communport>\n"+
                "<passive>"+passive+"</passive>\n"+
                "<downloaddir>" + XmlSpecChConv.convert(getDownloadDir()) + "</downloaddir>"+
                "<broadcastport>" + broadcastPortToSave + "</broadcastport>" +
                "</options>";
        
        pw.println(optionString);
        pw.flush();
        pw.close();
    }
    
    public static void loadOptionValues(String path) {
        File f = new File(path);
        try {
            if (!f.exists()) {
                f.createNewFile();
                writeOptionValues(f);
                
            } else {
                
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = docBuilder.parse(new InputSource(new FileReader(f)));
                Element root = doc.getDocumentElement();
                
                NodeList nl = root.getElementsByTagName("communport");
                int comListP = Integer.parseInt(nl.item(0).getTextContent());
                comListeningPort = comListP;
                setComListenPortToSave(comListP);
                
                nl = root.getElementsByTagName("broadcastport");
                int broadcPort = Integer.parseInt(nl.item(0).getTextContent());
                broadcastPort = broadcPort;
                setBroadcastPortToSave(broadcPort);
                
                nl = root.getElementsByTagName("passive");
                passive = Boolean.parseBoolean(nl.item(0).getTextContent());
                
                nl = root.getElementsByTagName("downloaddir");
                setDownloadDir(nl.item(0).getTextContent());
                
                
                
            }
            
        } catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        } catch (SAXException ex) {
            ex.printStackTrace();
        } catch (IOException ex) {
            ex.printStackTrace();
        } catch (NullPointerException ex) {
            ex.printStackTrace();
        }
        
        
    }
    
    
    
    public static String getName() {
        return profile.getName();
    }
    
    public static void setName(String aName) {
        profile.setName(aName);
    }
    
    public static String getPassword() {
        return profile.getPassword();
    }
    
    public static void setPassword(String aPassword) {
        profile.setPassword(aPassword);
    }
    
    public static String getDescription() {
        return profile.getDescription();
    }
    
    public static void setDescription(String aDescription) {
        profile.setDescription(aDescription);
    }
    
    
    public static int getCommunicationListeningPort() {
        return comListeningPort;
    }
    
    public static boolean isPassive() {
        return passive;
    }
    
    public static void setPassive(boolean aPassive) {
        passive = aPassive;
    }
    
    public static String getDownloadDir() {
        return downloadDir;
    }
    
    public static void setDownloadDir(String aDownloadDir) {
        downloadDir = aDownloadDir;
    }
    
    public static Profile getProfile() {
        return profile;
    }
    
    public static int getBroadcastPort() {
        return broadcastPort;
    }
    
    
    public static void setComListenPortToSave(int aComListenPortToSave) {
        comListenPortToSave = aComListenPortToSave;
    }
    
    public static void setBroadcastPortToSave(int aBroadcastPortToSave) {
        broadcastPortToSave = aBroadcastPortToSave;
    }
    
    public static String getClientID() {
        if (clientID == null) {
            try {
                NetworkInterface ni = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
                byte[] ha = ni.getHardwareAddress();
                clientID = "";
                
                for (int i = 0;i<ha.length;i++) {
                    if (ha[i] < 0) ha[i] = (byte)(256 - ha[i]);
                    clientID += Integer.toHexString(ha[i]);
                }
                
//                MessageDigest md = MessageDigest.getInstance("SHA-1");
//                clientID = new String(md.digest(ha));
            } catch (Exception ex) {
              //  ex.printStackTrace();
                clientID = Long.toString(new Random().nextLong());
            }
        }
        return clientID;
    }
    
}
