package client;

import common.AbstractFileDescriptor;
import exceptions.DBException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class OwnFileDescriptor extends AbstractFileDescriptor {
    private static Connection con;
    private short groupAccessibility;
    
    private String group;
    
    private static PreparedStatement getParentStatement;
    private static PreparedStatement getSubDirsStatement;
    private static PreparedStatement getSubFilesStatement;
    private static PreparedStatement isRootDirSt;
    private static PreparedStatement isRootFileSt;
    
    public OwnFileDescriptor(int file_id,String name,String extension,long size,String group,short paccess,short gaccess) {
        this(file_id,group,paccess,gaccess,name,extension,false,size);
    }
    
    public OwnFileDescriptor(int file_id,String name,String group,short paccess,short gaccess) {
        this(file_id,group,paccess,gaccess,name,null,true,-1);
    }
    
    private OwnFileDescriptor(int file_id,String group,short paccess,short gaccess,String name,String extension,boolean isDir,long size) {
        super(name,extension,isDir,size,paccess,file_id);
        groupAccessibility = gaccess;
        this.setGroup(group);
    }
    
    public List<OwnFileDescriptor> getFiles() {
        if (!isDirectory()) return null;
        try {
            ArrayList<OwnFileDescriptor> result;
            
            getSubDirsStatement.setInt(1,file_id);
            ResultSet rs = getSubDirsStatement.executeQuery();
            
            result = getDirFileDescriptors(rs);
            
            getSubFilesStatement.setInt(1,file_id);
            rs = getSubFilesStatement.executeQuery();
            
            result.addAll(getNormFileDescriptors(rs));
            
            return result;
        } catch (SQLException ex) {
            ex.printStackTrace();
            throw new DBException(ex);
        }
    }
    
    
    
    public void setFile_id(int val) {
        this.file_id = val;
    }
    
    
    public String getGroup() {
        return group;
    }
    
    public void setGroup(String val) {
        this.group = val;
    }
    
    
    public AbstractFileDescriptor getParent() {
        try {
            getParentStatement.setInt(1,file_id);
            getParentStatement.setInt(2,file_id);
            ResultSet rs = getParentStatement.executeQuery();
            ArrayList<OwnFileDescriptor> res =  getDirFileDescriptors(rs);
            if (res.size() > 0) return res.get(0);
            else
                return null;
        } catch (SQLException ex) {
            throw new DBException(ex);
        }
    }
    
    public static void setConnection(Connection c) throws SQLException {
        con = c;
        initPreparedStatemnts();
    }
    
    public boolean isRoot() {
      try {  
        if (isDirectory()) {
            isRootDirSt.setInt(1,getFile_id());
            ResultSet rs = isRootDirSt.executeQuery();
            return rs.next();
        } else {
            isRootFileSt.setInt(1,getFile_id());
            ResultSet rs = isRootFileSt.executeQuery();
            return rs.next();
        }
      } catch (SQLException ex) {
          throw new DBException(ex);
      }
    }
    
    private static void initPreparedStatemnts() throws SQLException {
        getParentStatement = con.prepareStatement("SELECT D.dir_id,D.dir_name,D.groupname,D.other_mode,D.group_mode FROM dirs D WHERE " +
                "D.dir_id in (SELECT F.parent_id FROM files F WHERE file_id = ? UNION SELECT D2.parent_id FROM dirs D2 WHERE" +
                " dir_id = ? )");
        
        getSubDirsStatement = con.prepareStatement("SELECT dir_id,dir_name,groupname,other_mode, group_mode FROM dirs WHERE parent_id = ?");
        getSubFilesStatement = con.prepareStatement("SELECT file_id,file_name,extension,size,groupname,other_mode, group_mode FROM files WHERE parent_id = ?");
        
        isRootDirSt = con.prepareStatement("SELECT * FROM dirs WHERE dir_id = ? and isroot <> 0");
        isRootFileSt = con.prepareStatement("SELECT * FROM files WHERE file_id = ? and isroot <> 0");    
    }
    
    /**
     *
     */
    public static ArrayList<OwnFileDescriptor> getNormFileDescriptors(ResultSet rs) throws SQLException {
        ArrayList<OwnFileDescriptor> result = new ArrayList<OwnFileDescriptor>();
        while (rs.next()) {
            result.add(new OwnFileDescriptor(rs.getInt("file_id"),rs.getString("file_name"),rs.getString("extension"),
                    rs.getLong("size"),rs.getString("groupname"),rs.getShort("other_mode"),rs.getShort("group_mode")));
        }
        return result;
    }
    
    public static ArrayList<OwnFileDescriptor> getDirFileDescriptors(ResultSet rs) throws SQLException {
        ArrayList<OwnFileDescriptor> result = new ArrayList<OwnFileDescriptor>();
        while (rs.next()) {
            result.add(new OwnFileDescriptor(rs.getInt("dir_id"),rs.getString("dir_name"),rs.getString("groupname"),
                    rs.getShort("other_mode"),rs.getShort("group_mode")));
        }
        return result;
    }
    
    public void setPublicAccessibility(short mode) {
        this.public_accessiblity = mode;
    }

    public short getGroupAccessibility() {
        return groupAccessibility;
    }

    public void setGroupAccessibility(short groupAccessibility) {
        this.groupAccessibility = groupAccessibility;
    }
    
}
