/*
 * AvailableTreeCellRenderer.java
 *
 * Created on 25 July 2007, 13:55
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package client.gui;

import common.StaticValues;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JTree;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultTreeCellRenderer;

/**
 *
 * @author A
 */
public class CommonTreeCellRenderer extends DefaultTreeCellRenderer implements StaticValues {
    private boolean forShareMgr;
    private static final Color Dowloadbale_File_Color = new Color(0,200,0);
    private static final Color Visible_File_Color = new Color(200,200,0);
    
    private HashMap<String,Icon> sufIcons = new HashMap<String,Icon>(50);
    /** Creates a new instance of AvailableTreeCellRenderer */
    public CommonTreeCellRenderer(boolean forShareMgr) {
        this.forShareMgr = forShareMgr;
    }
    
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        
        Component retValue;
        
        retValue = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        try {
            CommonTreeNode ctn = (CommonTreeNode)value;
            if (ctn.getAbstractFileDescriptor() == null) return retValue;
            
            if (leaf && ctn.getAbstractFileDescriptor().isDirectory()) {
                setIcon(getClosedIcon());
            } else if (leaf) {
                
                String name = ctn.toString();
                
                int index = name.lastIndexOf(".");
                String sufix = index == -1 ? "" : name.substring(index);
                
                
                Icon icon = sufIcons.get(sufix);
                
                if (icon == null) {
                    File f = File.createTempFile("3ch",sufix);
                    f.deleteOnExit();
                    icon = FileSystemView.getFileSystemView().getSystemIcon(f);
                    sufIcons.put(sufix,icon);
                }
                
                setIcon(icon);
            }
            
            
            
            if (ctn.getAbstractFileDescriptor() != null) {
                switch (ctn.getAbstractFileDescriptor().getPublicAccessiblity()) {
                    case DOWNLOADABLE_FILE   : setForeground(Dowloadbale_File_Color);break;
                    case VISIBLE_FILE        : setForeground(Visible_File_Color);break;
                    case NOT_ACCESSIBLE_FILE : setForeground(Color.RED);break;
                }
                
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return retValue;
    }
    
    
    
}
