/*
 * ClientTreeNode.java
 *
 * Created on 24 July 2007, 13:03
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package client.gui;

import client.OwnFileDescriptor;
import common.AbstractFileDescriptor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.tree.TreeNode;

/**
 *
 * @author A
 */
public class CommonTreeNode implements TreeNode {
    private ArrayList<CommonTreeNode> childNodes = null;
    private AbstractFileDescriptor abstractFileDescriptor = null;
    private TreeNode parent = null;
    
    /** Creates a new instance of ClientTreeNode */
    public CommonTreeNode(ArrayList<? extends AbstractFileDescriptor> rootFiles) {
        if (rootFiles != null) {
            childNodes = new ArrayList<CommonTreeNode>(rootFiles.size());
            for (AbstractFileDescriptor cfd : rootFiles) {
                childNodes.add(new CommonTreeNode(cfd,this));
            }
        }
    }
    
    public CommonTreeNode(AbstractFileDescriptor cfd, CommonTreeNode parent) {
        abstractFileDescriptor = cfd;
        this.parent = parent;
        
        if (cfd.getFiles() != null) {
            childNodes = new ArrayList<CommonTreeNode>(cfd.getFiles().size());
            for (AbstractFileDescriptor c : cfd.getFiles()) {
                if (!c.isRoot())
                    childNodes.add(new CommonTreeNode(c,this));
            }
        }
    }
    
    public boolean isLeaf() {
        return childNodes == null || childNodes.size() == 0;
    }
    
    public TreeNode getParent() {
        return parent;
    }
    
    public int getChildCount() {
        return childNodes == null ? 0 : childNodes.size();
    }
    
    public boolean getAllowsChildren() {
        return true;
    }
    
    public Enumeration children() {
        if (childNodes == null) return null;
        else
            return new Enumeration() {
                Iterator<CommonTreeNode> it =  childNodes.iterator();
                
                public boolean hasMoreElements() {
                    return it.hasNext();
                }
                public Object nextElement() {
                    return it.next();
                }
            };
    }
    
    public TreeNode getChildAt(int childIndex) {
        return childNodes.get(childIndex);
    }
    
    public int getIndex(TreeNode node) {
        return childNodes.indexOf(node);
    }
    
    public String toString() {
        if(getAbstractFileDescriptor() == null) return "null descriptor";
        
        if (getAbstractFileDescriptor().isDirectory()) {
            return getAbstractFileDescriptor().getFileName();
        } else {
            String ext = "." + getAbstractFileDescriptor().getExtension();
            
            return getAbstractFileDescriptor().getFileName() + (ext.length() > 1 ? ext : "") ;
        }
    }
    
    public AbstractFileDescriptor getAbstractFileDescriptor() {
        return abstractFileDescriptor;
    }
    
    public void addChildNode(CommonTreeNode c) {
        childNodes.add(c);
    }
    
    public void removeChildNode(CommonTreeNode c) {
        childNodes.remove(c);
    }
    
    
}
