/*
 * DownloadTableModel.java
 *
 * Created on 04 August 2007, 19:42
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package client.gui;

import common.Toolkit;
import client.net.transfer.FileReceiver;
import client.net.transfer.FileRecievingStateListener;
import client.net.transfer.RecieveInetrruptionEvent;
import client.net.transfer.ClientFileDescriptor;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

/**
 *
 * @author A
 */
public class DownloadTableModel extends AbstractTableModel implements FileRecievingStateListener {

    private ArrayList<FileReceiver> reciever = new ArrayList<FileReceiver>();
    private ArrayList<ProgressData> progData = new ArrayList<ProgressData>();
    private String[] columNames = new String[]{"File Name", "Size", "Completed", "Down Speed", "State"};
    private Timer timer;

    /** Creates a new instance of DownloadTableModel */
    public DownloadTableModel() {
        timer = new Timer();
        timer.schedule(new TimerTask() {

            public void run() {
                SwingUtilities.invokeLater(new Runnable() {

                    public void run() {
                        fireTableRowsUpdated(0, getRowCount() - 1);
                    }
                });
            }
        }, 0, FileSendTableModel.REFRESH_PERIOD);

    }

    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        FileReceiver fr = reciever.get(rowIndex);
        ClientFileDescriptor cfd = fr.getClientFileDescriptor();
        switch (columnIndex) {
            case 0: {
                String name = cfd.getFileName() + (cfd.getExtension().length() > 0 ? "." + cfd.getExtension() : "");
                return name;
            }
            case 1:
                return Toolkit.formatSize(cfd.getSize());
            case 2:
                return (long) (((long) fr.getProgress()) * 100 / fr.getFileSize()) + " %";
            case 3: {
                if (fr.getState().equals(FileReceiver.RECIEVING)) {
                    ProgressData pd = progData.get(rowIndex);
                    long progDif = fr.getProgress() - pd.getTranferred();
                    double timeDif = ((double) (System.currentTimeMillis() - pd.getMilliseconds())) / 1000;
                    long res = (long) (progDif / timeDif);
                    pd.setMilliseconds(System.currentTimeMillis());
                    pd.setTranferred(fr.getProgress());
                    return Toolkit.formatSize(res) + " / s";
                } else {
                    return "N/A";
                }
            }
            case 4: {
                return fr.getState();
            }
        }
        return null;
    }

    public synchronized int getRowCount() {
        return reciever.size();
    }

    public synchronized int getColumnCount() {
        return columNames.length;
    }

    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void recieveIneterrupted(RecieveInetrruptionEvent evt) {
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                fireTableDataChanged();
            }
        });
    }

    public synchronized void recieveStarted(final FileReceiver f) {

        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                reciever.add(f);
                progData.add(new ProgressData(System.currentTimeMillis(), f.getProgress()));
                fireTableDataChanged();
            }
        });
    }

    public void recieveCompleted(FileReceiver f) {
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                fireTableDataChanged();
            }
        });
    }

    public String getColumnName(int column) {
        return columNames[column];
    }

    public synchronized void clear() {
        for (int i = reciever.size() - 1; i >= 0; i--) {
            String state = reciever.get(i).getState();
            if (state == FileReceiver.RECIEVE_COMPLETED || state == FileReceiver.INTERRUPTED) {
                reciever.remove(i);
            }
            progData.remove(i);
        }
        fireTableDataChanged();
    }

    public FileReceiver getFileReciever(int row) {
        return reciever.get(row);
    }

    public void recieveCannotStart(final FileReceiver f) {
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                reciever.add(f);
                progData.add(new ProgressData(System.currentTimeMillis(), f.getProgress()));
                fireTableDataChanged();
            }
        });
    }
}
