/*
 * IncomingConnectionsTableModel.java
 *
 * Created on 04 June 2007, 23:53
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package client.gui;

import client.net.commun.ClientListener;
import client.net.commun.HumpClient;
import client.net.commun.NormalClient;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

/**
 *
 * @author A
 */
public class IncomingConnectionsTableModel extends AbstractTableModel implements ClientListener {

    private ArrayList<HumpClient> clients = new ArrayList<HumpClient>();
    private static String[] colNames = new String[]{"Name", "Description", "Passive", "Registered"};

    /** Creates a new instance of IncomingConnectionsTableModel */
    public IncomingConnectionsTableModel() {

    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        HumpClient nc = clients.get(rowIndex);
        switch (columnIndex) {
            case 0:
                return nc.getName();
            case 1:
                return nc.getDescription();
            case 2:
                return nc.isPassive();
            case 3:
                return nc.isRegistered();
            default:
                return null;
        }
    }

    public int getRowCount() {
        return clients.size();
    }

    public int getColumnCount() {
        return colNames.length;
    }

    public String getColumnName(int column) {
        return colNames[column];
    }

    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0:
                return String.class;
            case 1:
                return String.class;
            case 2:
                return Boolean.class;
            case 3:
                return Boolean.class;
            default:
                return null;
        }
    }

    public void clientConnected(final HumpClient nc) {
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                clients.add(nc);
                fireTableDataChanged();
            }
        });
    }

    public void clientStateChanged(final HumpClient nc) {
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                fireTableDataChanged();
            }
        });
    }

    public void clientDisconnected(final HumpClient nc) {
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                clients.remove(nc);
                fireTableDataChanged();
            }
        });
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public HumpClient getHumpClient(int row) {
        return clients.get(row);
    }
}
