/*
 * LANClientListModel.java
 *
 * Created on 06 October 2007, 22:07
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package client.gui;

import client.net.lan.LANClientDescriptor;
import client.net.lan.LANClientsListener;
import java.util.Vector;
import javax.swing.AbstractListModel;

/**
 *
 * @author A
 */
public class LANClientListModel extends AbstractListModel implements LANClientsListener{
    private Vector<LANClientDescriptor> clients = new Vector<LANClientDescriptor>();
    /** Creates a new instance of LANClientListModel */
    public LANClientListModel() {
    }

    public int getSize() {
        return clients.size();
    }

    public Object getElementAt(int index) {
        return clients.get(index).getName(); //+ " (" +clients.get(index).getHost().getHostAddress()+")";
    }
    
    public void possibleLANClientFound(LANClientDescriptor d) {
        clients.add(d);
        fireIntervalAdded(this,clients.size()-1,clients.size()-1);
    }

    public void listRefresh() {
        int index2 = clients.size()-1;
        clients.clear();
        fireIntervalRemoved(this,0,index2 < 0 ? 0 : index2);
    }
    
    public LANClientDescriptor getDescriptorAt(int index) {
        return clients.get(index);
    }
}
