/*
 * ServersTableModel.java
 *
 * Created on 05 August 2007, 19:23
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package client.gui;

import client.net.commun.PossibleClientDescriptor;
import client.net.commun.ServerClient;
import client.net.commun.ServerConnectionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

/**
 *
 * @author A
 */
public class ServersTableModel extends AbstractTableModel implements ServerConnectionListener {

    private Vector<ServerClient> serverClients = new Vector<ServerClient>();
    private String[] cols = new String[]{"Server Name", "Client count"};

    /** Creates a new instance of ServersTableModel */
    public ServersTableModel() {
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        ServerClient c = serverClients.get(rowIndex);
        switch (columnIndex) {
            case 0:
                return c.getName();
            case 1:
                return "" + c.getClientCount();
        }
        return null;
    }

    public int getRowCount() {
        return serverClients.size();
    }

    public int getColumnCount() {
        return cols.length;
    }

    public void serverStateChanged(ServerClient s) {
        fireTableDataChanged();
    }

    public void disconnectedFromServer(ServerClient s) {
        serverClients.remove(s);
        fireTableDataChanged();
    }

    public void connectedToServer(ServerClient s) {
        serverClients.add(s);
        fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public String getColumnName(int column) {
        return cols[column];
    }

    public ServerClient getServerClient(int row) {
        return serverClients.get(row);
    }

    public void clientConnectedToServer(final ServerClient s, PossibleClientDescriptor pcd) {
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                fireTableCellUpdated(serverClients.indexOf(s), 1);
            }
        });
    }

    public void clientDisconnectedFromServer(final ServerClient s, PossibleClientDescriptor pcd) {
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                fireTableCellUpdated(serverClients.indexOf(s), 1);
            }
        });
    }
}
