/*
 * ShareSelectionOptionPanel.java
 *
 * Created on 25 July 2007, 17:15
 */

package client.gui;

import client.ShareManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.sql.SQLException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFileChooser;

/**
 *
 * @author  A
 */
public class ShareSelectionOptionPanel extends javax.swing.JPanel implements PropertyChangeListener {
    public static final int SHARE_FILE_AS_ROOT = 1;
    public static final int SHARE_WITH_PARENT_AS_ROOT = 2;
    public static final int PARENT_SHARED_SHARE_AS_SUBFILE = 3; 
    
    private ShareManager sharingManager;
    private JFileChooser fileChooser;
    /** Creates new form ShareSelectionOptionPanel */
    public ShareSelectionOptionPanel(ShareManager sm,JFileChooser fc) {
        this.sharingManager = sm;
        this.fileChooser = fc;
        initComponents();
        
      
    }
    
    /** Sets the accessory commponents,
     *  if file's parent is shared
     */
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        
        
        if (JFileChooser.SELECTED_FILES_CHANGED_PROPERTY.equals(prop) && evt.getNewValue() != null) {
            File[] files = (File[]) evt.getNewValue();
            
            // false - must be initialized
            boolean file_shared_anc = false;
            boolean file_is_set = false;
            
            // false - must be initialized
            boolean dir_shared_anc = false;
            boolean dir_is_set = false;
            try {
                for (File f : files) {
                    if (f.isDirectory()) {
                        if (dir_is_set) continue;
                        dir_shared_anc = sharingManager.isAncSharedAsRoot(f);
                        dir_is_set = true;
                    } else {
                        if (file_is_set) continue;
                        file_shared_anc = sharingManager.isAncSharedAsRoot(f);
                        file_is_set = true;
                    }
                }
                
                if (file_is_set) {
                    if (file_shared_anc) {
                        shareAsRootRB.setEnabled(true);
                        shareNormRB.setEnabled(true);
                        shareParentRB.setEnabled(false);
                        
                        shareNormRB.setSelected(true);
                    } else {
                        shareAsRootRB.setEnabled(true);
                        shareParentRB.setEnabled(true);
                        shareNormRB.setEnabled(false);
                    }
                } else {
                    shareAsRootRB.setEnabled(false);
                    shareNormRB.setEnabled(false);
                    shareParentRB.setEnabled(false);
                    
//                    shareAsRootRB.setSelected(false);
//                    shareNormRB.setSelected(false);
//                    shareParentRB.setSelected(false);
                }
                
                if (dir_is_set) {
                    if (dir_shared_anc) {
                        //    dirShareCB.setSelected(false);
                        dirShareCB.setEnabled(true);
                    } else {
                        dirShareCB.setSelected(true);
                        dirShareCB.setEnabled(false);
                    }
                } else {
                    dirShareCB.setSelected(false);
                    dirShareCB.setEnabled(false);
                }
                
            } catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }
    
    public int getFileSharePolicy() {
        if (shareNormRB.isSelected()) {
            return PARENT_SHARED_SHARE_AS_SUBFILE;
        } else if (shareAsRootRB.isSelected()) {
            return SHARE_FILE_AS_ROOT;
        } else {
            return SHARE_WITH_PARENT_AS_ROOT;
        }
    }
    
    public boolean getShareDirAsRoot() {
        return dirShareCB.isSelected();
    }
    
    public String getSelectedGroup() {
        return (String)groupCB.getSelectedItem();
    }
    
    public short getPublicAccess() {
        return (short)(publicAccCB.getSelectedIndex()+1);
    }
    
    public short getGroupAccess() {
        return (short)(groupAccComboBox.getSelectedIndex() +1);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jPanel2 = new javax.swing.JPanel();
        filesButtonGroup = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        shareParentRB = new javax.swing.JRadioButton();
        shareAsRootRB = new javax.swing.JRadioButton();
        shareNormRB = new javax.swing.JRadioButton();
        jPanel3 = new javax.swing.JPanel();
        dirShareCB = new javax.swing.JCheckBox();
        jPanel4 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        publicAccCB = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();
        groupCB = new javax.swing.JComboBox();
        jLabel3 = new javax.swing.JLabel();
        groupAccComboBox = new javax.swing.JComboBox();

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Files"));
        filesButtonGroup.add(shareParentRB);
        shareParentRB.setText("Share parent folder as root");
        shareParentRB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        shareParentRB.setMargin(new java.awt.Insets(0, 0, 0, 0));

        filesButtonGroup.add(shareAsRootRB);
        shareAsRootRB.setText("Share file as root");
        shareAsRootRB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        shareAsRootRB.setMargin(new java.awt.Insets(0, 0, 0, 0));

        filesButtonGroup.add(shareNormRB);
        shareNormRB.setText("Parent shared, share as subfile");
        shareNormRB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        shareNormRB.setMargin(new java.awt.Insets(0, 0, 0, 0));

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(shareNormRB)
                    .addComponent(shareParentRB)
                    .addComponent(shareAsRootRB))
                .addContainerGap(26, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addComponent(shareNormRB)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(shareParentRB)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(shareAsRootRB)
                .addContainerGap())
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Directories"));
        dirShareCB.setText("Share as root");
        dirShareCB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        dirShareCB.setMargin(new java.awt.Insets(0, 0, 0, 0));

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addComponent(dirShareCB)
                .addContainerGap(110, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(dirShareCB, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createTitledBorder("Access")));
        jLabel1.setText("public access");

        publicAccCB.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Not Available", "Visible", "Downloadable" }));

        jLabel2.setText("group");

        groupCB.setModel(new DefaultComboBoxModel(sharingManager.getGroups().toArray()));

        jLabel3.setText("group access");

        groupAccComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Not Available", "Visible", "Downloadable" }));

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addComponent(jLabel2)
                        .addGap(49, 49, 49)
                        .addComponent(groupCB, 0, 98, Short.MAX_VALUE))
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel1)
                            .addComponent(jLabel3))
                        .addGap(14, 14, 14)
                        .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(groupAccComboBox, 0, 98, Short.MAX_VALUE)
                            .addComponent(publicAccCB, 0, 98, Short.MAX_VALUE))))
                .addContainerGap())
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(groupCB, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(publicAccCB, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel1))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(groupAccComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(21, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addComponent(jPanel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, 89, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox dirShareCB;
    private javax.swing.ButtonGroup filesButtonGroup;
    private javax.swing.JComboBox groupAccComboBox;
    private javax.swing.JComboBox groupCB;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JComboBox publicAccCB;
    private javax.swing.JRadioButton shareAsRootRB;
    private javax.swing.JRadioButton shareNormRB;
    private javax.swing.JRadioButton shareParentRB;
    // End of variables declaration//GEN-END:variables
    
}
