/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package client.net;

import common.commun.NoHandlerForConnectionTypeException;
import common.commun.TrafficHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *Purpose of this class is to make ATP and PTP connection waiting transparent to managers.
 * @author Ati
 */
public class PendingConnectionController {

    private final TrafficHandler trafficHandler;
    private final ConnectionProvider con;

    public PendingConnectionController(TrafficHandler th, ConnectionProvider con) {
        trafficHandler = th;
        this.con = con;
    }

    private void sendMessage(BufferedWriter bw, String msg) throws IOException {
        bw.write(msg, 0, msg.length());
        bw.newLine();
        bw.flush();
    }

    public void createPendingConnection(String host,int port,String msg) {
        PendingRunnable pnd = new PendingRunnable(host, port, msg);
        Thread t = new Thread(pnd,"pending connection handler thread");
        t.start();
    }
    

    private class PendingRunnable implements Runnable {

        private String msg;
        private int port;
        private String host;

        public PendingRunnable(String host, int port, String message) {
            this.msg = message;
            this.host = host;
            this.port = port;
        }

        public void run() {
            try {
                Socket s = con.connectTo(host, port);
                OutputStream os = s.getOutputStream();
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
                sendMessage(bw, msg);
                InputStream is = s.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String reply = br.readLine();
                trafficHandler.processConnection(s, os, is, reply);
            } catch (NoHandlerForConnectionTypeException ex) {
                ex.printStackTrace();
                Logger.getLogger(PendingConnectionController.class.getName()).log(Level.SEVERE, null, ex);
            } catch (IOException ex) {
                ex.printStackTrace();
                Logger.getLogger(PendingConnectionController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
    
//        public void handleATPTransferConnection(final String host, final int port) {
//        Runnable toRun = new Runnable() {
//
//            public void run() {
//                try {
//                    Socket s = con.connectTo(host, port);
//                    OutputStream os = s.getOutputStream();
//                    BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
//
//                    String tosend = "<msg type = \"" + StaticProtocolStrings.TOACT_FROM_PASSIVE_TRANS_REPLY +
//                            "\" ><id>" + OptionalValueProvider.getClientID() + "</id>" +
//                            "</msg>";
//
//                    sendMessage(bw, tosend);
//
//                    InputStream is = s.getInputStream();
//                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
//                    String msg = br.readLine();
//                    trafficHandler.processConnection(s, os, is, msg);
//                } catch (NoHandlerForConnectionType ex) {
//                    ex.printStackTrace();
//                    Logger.getLogger(PendingConnectionController.class.getName()).log(Level.SEVERE, null, ex);
//                } catch (IOException ex) {
//                    ex.printStackTrace();
//                    Logger.getLogger(PendingConnectionController.class.getName()).log(Level.SEVERE, null, ex);
//                }
//            }
//        };
//
//        Thread handlerThread = new Thread(toRun, "ATP transfer pending connection handler thread");
//        handlerThread.start();
//    }

}
