package client.net.commun;

import common.commun.LineMessageReciever;
import common.commun.LineMessageSender;
import common.commun.MessageReciever;
import common.commun.MessageSender;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractClient {

    public static final String UNKNOWN_CLIENT_NAME = "unknown";
    protected Socket socket;
    protected String name = UNKNOWN_CLIENT_NAME;
    //protected BufferedReader messageReciever;
    protected MessageReciever messageReciever;
    protected MessageSender messageSender;
    protected ClientManager clientManager;
    protected Thread messageWaiterThread;

    public AbstractClient(ClientManager cm, Socket s, InputStream is, OutputStream os) throws IOException {
        clientManager = cm;
        socket = s;
        this.messageSender = new LineMessageSender(os);
        this.messageReciever = new LineMessageReciever(is);
        //this.messageReciever = new BufferedReader(new InputStreamReader(is));
    }

    public String getIPAdress() {
        return socket.getInetAddress().getHostAddress();
    }

    public int getCommunicationPort() {
        return socket.getPort();
    }

    public String getName() {
        return name;
    }

    protected void disconnectSocket() {
        try {
            messageSender.close();
        } catch (IOException ex) {
            Logger.getLogger(AbstractClient.class.getName()).log(Level.SEVERE, null, ex);
        }

        try {
            messageReciever.close();
        } catch (IOException ex) {
            Logger.getLogger(AbstractClient.class.getName()).log(Level.SEVERE, null, ex);
        }

        try {
            socket.close();
        } catch (IOException ex) {
            Logger.getLogger(AbstractClient.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void sendMessage(final String msg) {
        Thread t = new Thread(new Runnable() {
            public void run() {
                sendMessageHlp(msg);
            }
        });
        t.start();
    }

    protected void sendMessage(int type) {
        sendMessage(getMessage(type));
    }

    private synchronized void sendMessageHlp(final String msg) {
        try {
            messageSender.sendMessage(msg);
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected abstract String getMessage(int type);
}
