/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package client.net.commun;

import client.net.commun.AbstractClient;
import client.net.commun.ClientManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

/**
 *
 * @author Ati
 */
public abstract class AbstractNormalClient extends AbstractClient implements Runnable {

    public static final String CONNECTED_STATE = "Connected";
    public static final String INITIALIZING_STATE = "Initializing";
    public static final String DISCONNECTED_STATE = "Disconnected";
    protected String description;
    protected boolean passive;
    protected String state = INITIALIZING_STATE;
    protected DocumentBuilder docBuilder;
    protected String id;
    /** 
     * 
     * @param cm
     * @param s
     * @param is
     * @param os
     * @param passive
     * @param startMessageWaiterThread - in HumpClient must be false, becouse 
     * of initalization of messageDiggest object which is used at message processing.
     * @throws java.io.IOException
     */
    public AbstractNormalClient(ClientManager cm, Socket s, InputStream is, OutputStream os, boolean passive,
            boolean startMessageWaiterThread) throws IOException {
        super(cm, s, is, os);
        try {
            this.passive = passive;
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            
            messageWaiterThread = new Thread(this);
            if (startMessageWaiterThread) {
                messageWaiterThread.start();
            }
        } catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        }

    }

    public boolean isPassive() {
        return passive;
    }

    public String getState() {
        return state;
    }


    protected String getMessage(int type) {
        switch (type) {
            default:
                return "";
        }
    }

    public String getDescription() {
        return description;
    }

    public String getID() {
        return id;
    }
}
