package client.net.commun;

import client.net.*;
import client.net.commun.ServerClient;
import client.net.commun.ServerConnectionListener;
import client.*;
import client.net.lan.LANClientDescriptor;
import common.XmlSpecChConv;
import common.commun.ConnectionData;
import common.commun.ConnectionHandler;
import common.commun.StaticProtocolStrings;
import common.commun.TrafficHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class ClientManager implements ServerConnectionListener, ClientListener, OutgoingConnectionListener, ConnectionHandler,
        StaticProtocolStrings {

    private ArrayList<ClientListener> clientListeners = new ArrayList<ClientListener>(2);
    private ArrayList<OutgoingConnectionListener> outConListeners = new ArrayList<OutgoingConnectionListener>(2);
    private ArrayList<ServerConnectionListener> serverConListeners = new ArrayList<ServerConnectionListener>();
    private Vector<ServerClient> serverClients = new Vector<ServerClient>();
    private Vector<NormalClient> normalClients = new Vector<NormalClient>();
    private Vector<HumpClient> humpClients = new Vector<HumpClient>();
    private InfoProvider infoProvider;
    private ConnectionProvider connector;
    // maps might be replaced : make one of two, and allow to have multiple keys.
    private HashMap<String, Profile> expectedConProfiles = new HashMap<String, Profile>();
    private HashMap<String, Profile> ptpConnectionProfile = new HashMap<String, Profile>();
    private PendingConnectionController pendingConnectionController;

    public ClientManager(InfoProvider infoProv, ConnectionProvider c, TrafficHandler th) {
        infoProvider = infoProv;
        this.connector = c;
        this.pendingConnectionController = new PendingConnectionController(th, c);
        addServerConnectionListener(this);
        addClientListener(this);
        addOutgoingConnectionListener(this);
    }

    private static String getConnectionIntroductionMessage() {
        return "<connection type = \"" + NORM_CON_TYPE_TO_CLIENT + "\"/>";
    }

    public void connectToNonServerClient(LANClientDescriptor d, Profile p) throws IOException {
        connectToNonServerClient(d.getHost().getHostAddress(), d.getPort(), p);
    }

    public void connectToNonServerClient(LANClientDescriptor d) throws IOException {
        connectToNonServerClient(d.getHost().getHostAddress(), d.getPort());
    }

    public void connectToNonServerClient(String host, int port) throws IOException {
        connectToNonServerClient(host, port, OptionalValueProvider.getProfile());
    }

    public void connectToNonServerClient(String host, int port, Profile profile) throws IOException {
        Socket s = connector.connectTo(host, port);
        OutputStream os = s.getOutputStream();

        ConnectionMediator.sendMessages(os, new String[]{getConnectionIntroductionMessage()});
        NormalClient nc = new NormalClient(this, s, os, s.getInputStream(), (Profile) profile.clone());
        normalClients.add(nc);
    }

    public synchronized void connectToPossibleClient(PossibleClientDescriptor pcd, Profile p) throws IOException {

        if (pcd.isPassive() && OptionalValueProvider.isPassive()) {
            addPtPConnectionProfile(pcd.getId(), p);
            pcd.getOwner().sendPtPConnectionRequest(pcd);
        } else if (pcd.isPassive() && !OptionalValueProvider.isPassive()) {
            addExpectedConnectionProfile(pcd.getId(), p);
            pcd.getOwner().sendPassiveConnectionRequest(pcd);
        } else if (!pcd.isPassive()) {
            connectToNonServerClient(pcd.getIpAddress(), pcd.getConnectionPort(), p);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    void handleComConnectionToBride(String host, int port, String remID, ServerClient conHelper) {
        try {
            String tosend = "<con type = \"" + StaticProtocolStrings.TO_BRIDGE_CONN_TYPE + "\">" +
                    "<pur>" + StaticProtocolStrings.BRIDGE_CON_PURPOSE_COMM + "</pur>" +
                    "<role>" + StaticProtocolStrings.BRIDGE_CON_ROLE_REQ + "</role>" +
                    "<id>" + XmlSpecChConv.convert(OptionalValueProvider.getClientID()) + "</id>" +
                    "</con>";

            ConnectionMediator cm = new ConnectionMediator(connector, host, port,
                    new String[]{tosend, getConnectionIntroductionMessage()});

            PossibleClientDescriptor pc = conHelper.getPosClientDescriptor(remID);

            NormalClient nc = new NormalClient(this, cm.getSocket(), cm.getOutputStream(),
                    cm.getInputStream(), retrivePtPConnectionProfile(remID), conHelper, pc.getConnectionPort());
            normalClients.add(nc);
        } catch (IOException ex) {
            ex.printStackTrace();
            Logger.getLogger(ClientManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Vector<ServerClient> getServerClients() {
        return serverClients;
    }

    public void addServerClient(ServerClient sc) {
        serverClients.add(sc);
    }

    public void disconnectServerClient(ServerClient sc) {
        serverClients.remove(sc);
    }

    public Vector<NormalClient> getNormalClients() {
        return normalClients;
    }

    public void addNonServerClient(NormalClient nsc) {
        normalClients.add(nsc);
    }

    public void disconnectNonServerClient(NormalClient nc) {
        normalClients.remove(nc);
        nc.disconnect();

    }

    public synchronized void processConnection(ConnectionData data) {
        try {

            Element root = data.getDoc().getDocumentElement();
            String conType = root.getAttribute("type");


            if (conType.equals(NORM_CON_TYPE_TO_CLIENT)) {
                HumpClient c = new HumpClient(this, data.getSocket(), data.getInputStream(), infoProvider);
                humpClients.add(c);
            } else if (conType.equals(ACTTOPASS_CON_TYPE)) {
                String id = root.getElementsByTagName("id").item(0).getTextContent();
                String serverID = root.getElementsByTagName("serverid").item(0).getTextContent();
                int comport = Integer.parseInt(root.getElementsByTagName("comport").item(0).getTextContent());

                Profile profile = retriveExpectedProfile(id);

                if (profile == null) {
                    profile = OptionalValueProvider.getProfile();
                }

                ServerClient server = null;
                for (ServerClient c : serverClients) {
                    if (c.getID().equals(serverID)) {
                        server = c;
                        break;
                    }
                }

                ConnectionMediator.sendMessages(data.getOutputStream(), new String[]{getConnectionIntroductionMessage()});
                NormalClient nc = new NormalClient(this, data.getSocket(),
                        data.getOutputStream(), data.getInputStream(), profile, server, comport);
                normalClients.add(nc);
//            } else if (conType.equals(TOACTO_FROM_PASS_SERVER_REQ)) {
//
//                String ip = root.getElementsByTagName("ip").item(0).getTextContent();
//                int port = Integer.parseInt(root.getElementsByTagName("port").item(0).getTextContent());
//                Socket s = socketFactory.createSocket(ip, port);
//                HumpClient hc = new HumpClient(this, s, infoProvider);
//                humpClients.add(hc);
//                hc.sendATPConMessage();

            } else {
                try {
                    data.getOutputStream().close();
                } catch (IOException e) {
                }

                try {
                    data.getInputStream().close();
                } catch (IOException e) {
                }

                try {
                    data.getSocket().close();
                } catch (IOException e) {
                }

            }

        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    void connectAsATPReply(String ip, int port, String serverID) {
        String atpConMsg = "<msg type = \"" + StaticProtocolStrings.ACTTOPASS_CON_TYPE + "\">" +
                "<id>" + XmlSpecChConv.convert(OptionalValueProvider.getClientID()) + "</id>" +
                "<comport>" + OptionalValueProvider.getCommunicationListeningPort() + "</comport>" +
                "<serverid>" + XmlSpecChConv.convert(serverID) + "</serverid>" +
                "</msg>";

        pendingConnectionController.createPendingConnection(ip, port, atpConMsg);
    }

    public void connectToServer(String ip, int port) throws IOException {
        Socket s = connector.connectTo(ip, port);
//        BufferedReader br = new BufferedReader(new InputStreamReader(s.getInputStream()));
//        System.out.println(br.readLine());

        ServerClient sc = new ServerClient(s, this, infoProvider);
    }

    private Profile retrivePtPConnectionProfile(String s) {
        synchronized (ptpConnectionProfile) {
            return ptpConnectionProfile.remove(s);
        }
    }

    private void addPtPConnectionProfile(String id, Profile p) {
        synchronized (ptpConnectionProfile) {
            ptpConnectionProfile.put(id, p);
        }
    }

    private synchronized Profile retriveExpectedProfile(String id) {

        return expectedConProfiles.remove(id);
    }

    private synchronized void addExpectedConnectionProfile(String id, Profile p) {
        expectedConProfiles.put(id, p);
    }

    public void addClientListener(ClientListener cl) {
        clientListeners.add(cl);
    }

    public boolean removeClientListener(ClientListener cl) {
        return clientListeners.remove(cl);
    }

    public void fireClientStateChanged(HumpClient nc) {
        for (ClientListener cl : clientListeners) {
            cl.clientStateChanged(nc);
        }
    }

    public void fireClientConnected(HumpClient nc) {
        for (ClientListener cl : clientListeners) {
            cl.clientConnected(nc);
        }
    }

    public void fireClientDisconnected(HumpClient nc) {
        for (ClientListener cl : clientListeners) {
            cl.clientDisconnected(nc);
        }
    }

    public void addOutgoingConnectionListener(OutgoingConnectionListener cl) {
        outConListeners.add(cl);
    }

    public boolean removeOutgoingConnectionListener(OutgoingConnectionListener cl) {
        return outConListeners.remove(cl);
    }

    public void fireOutClientStateChanged(NormalClient nc) {
        for (OutgoingConnectionListener cl : outConListeners) {
            cl.clientStateChanged(nc);
        }
    }

    public void fireConnectedToClient(NormalClient nc) {
        for (OutgoingConnectionListener cl : outConListeners) {
            cl.connectedToClient(nc);
        }
    }

    public void fireDisconnectedFrom(NormalClient nc) {
        for (OutgoingConnectionListener cl : outConListeners) {
            cl.disconnectedFrom(nc);
        }
    }

    public void addServerConnectionListener(ServerConnectionListener l) {
        serverConListeners.add(l);
    }

    public void removeServerConnectionListener(ServerConnectionListener l) {
        serverConListeners.remove(l);
    }

    public void fireConnectedToServer(ServerClient sc) {
        for (ServerConnectionListener l : serverConListeners) {
            l.connectedToServer(sc);
        }
    }

    public void fireDisconnectedFromServer(ServerClient sc) {
        for (ServerConnectionListener l : serverConListeners) {
            l.disconnectedFromServer(sc);
        }
    }

    public void fireClientDisconnectedFromServer(ServerClient sc,PossibleClientDescriptor pcd) {
        for (ServerConnectionListener l : serverConListeners) {
            l.clientDisconnectedFromServer(sc, pcd);
        }
    }

    public void fireClientConnectedToServer(ServerClient sc,PossibleClientDescriptor pcd) {
        for (ServerConnectionListener l : serverConListeners) {
            l.clientConnectedToServer(sc, pcd);
        }
    }

    public void fireServerStateChanged(ServerClient sc) {
        for (ServerConnectionListener l : serverConListeners) {
            l.serverStateChanged(sc);
        }
    }

    public void serverStateChanged(ServerClient s) {
    }

    public void disconnectedFromServer(ServerClient s) {
        serverClients.remove(s);
    }

    public void connectedToServer(ServerClient s) {
        serverClients.add(s);
    }

    public void clientStateChanged(HumpClient nc) {
    }

    public void clientDisconnected(HumpClient nc) {
        humpClients.remove(nc);

    }

    public void clientConnected(HumpClient nc) {
    // humpClients.add(nc);
    }

    public void disconnectedFrom(NormalClient nc) {
        normalClients.remove(nc);
    }

    public void connectedToClient(NormalClient nc) {
    //  normalClients.add(nc);
    }

    public void clientStateChanged(NormalClient nc) {
    }

    public String[] getTypesToHandle() {
        return new String[]{NORM_CON_TYPE_TO_CLIENT, ACTTOPASS_CON_TYPE};
    }

    public PendingConnectionController getPendingConnectionController() {
        return pendingConnectionController;
    }

    public void clearNormalClients() {
        for (int i = normalClients.size() - 1; i >= 0; i--) {
            if (normalClients.get(i).getState() == AbstractNormalClient.DISCONNECTED_STATE) {
                fireDisconnectedFrom(normalClients.get(i));
            }
        }
    }

    public void clientConnectedToServer(ServerClient s, PossibleClientDescriptor pcd) {
    }

    public void clientDisconnectedFromServer(ServerClient s, PossibleClientDescriptor pcd) {
    }
}
