package client.net.transfer;

import common.*;
import client.net.commun.NormalClientDescriptor;
import java.util.ArrayList;

public class ClientFileDescriptor extends AbstractFileDescriptor {
    private ClientFileDescriptor parent = null;
    private ArrayList<ClientFileDescriptor> files = null;
    private NormalClientDescriptor normalClientDescriptor;
    
    private boolean root = false;
    
    /**constructor for directory*/
    public ClientFileDescriptor(String name,ClientFileDescriptor parent,NormalClientDescriptor ncd,short accessibilty,int id,ArrayList<ClientFileDescriptor> files,boolean isRoot) {
        this(name,null,true,-1,parent,ncd,files,accessibilty,id,isRoot);
    }
    
    public ClientFileDescriptor(String name,String extension,long size,ClientFileDescriptor parent,NormalClientDescriptor ncd,short accessibilty,int id,boolean isRoot) {
        this(name,extension,false,size,parent,ncd,null,accessibilty,id,isRoot);
    }
    
    private ClientFileDescriptor(String name,String extension,boolean isDir,long size,ClientFileDescriptor parent,NormalClientDescriptor ncd,
            ArrayList<ClientFileDescriptor> files,short accessibilty,int id,boolean isRoot) {
        super(name,extension,isDir,size,accessibilty,id);
        this.parent = parent;
        this.setFiles(files);
        this.root = isRoot;
        this.normalClientDescriptor = ncd;
    }
    
    public ArrayList<ClientFileDescriptor> getFiles() {
        return files;
    }
    
    public void setFiles(ArrayList<ClientFileDescriptor> files) {
        this.files = files;
    }
    
    public NormalClientDescriptor getNormalClientDescriptor() {
        return normalClientDescriptor;
    }
    
//    public void setNormalClientDescriptor(NormalClientDescriptor val) {
//        this.normalClientDescriptor = val;
//    }
    
    public AbstractFileDescriptor getParent() {
        return parent;
    }

    public boolean isRoot() {
        return root;
    }
}
