package client.net.transfer;

import client.Profile;
import client.net.commun.NormalClientDescriptor;
import client.net.transfer.ClientFileDescriptor;
import common.XmlSpecChConv;
import common.commun.StaticProtocolStrings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FileReceiver extends FileTransferer implements Runnable {

    public static final String INITIALIZING = "Initializing";
    public static final String RECIEVING = "Recieving";
    public static final String RECIEVE_COMPLETED = "Recieve Completed";
    public static final String INTERRUPTED = "Interrupted";
    public static final String CANNOT_START = "Can't start";
    public static final String PAUSED = "Paused";
    private static int BUFFER_SIZE = 8192;
    private String path;
    private File file;
    private ClientFileDescriptor cfd;
    private BufferedWriter bw;
    private InputStream is;
    private Socket socket;
    private DocumentBuilder docBuilder;
    private TransferManager transferManager;
    private Thread receiverThread;
    private long progress = 0;
    private String state = INITIALIZING;
    private volatile boolean paused = false;

    public FileReceiver(String path, ClientFileDescriptor cfd, Socket s, TransferManager tm) throws IOException {
        this(path, cfd, s, s.getOutputStream(), s.getInputStream(), tm);
    }

    public FileReceiver(String path, ClientFileDescriptor cfd, Socket s, OutputStream os, InputStream is, TransferManager tm) {
        super(is, os);
        this.path = path;
        this.cfd = cfd;
        this.socket = s;
        this.transferManager = tm;
        try {
            this.is = is;
            this.bw = new BufferedWriter(new OutputStreamWriter(os));


            String msg = getFileDownloadMessage(cfd);
            messageSender.sendMessage(msg);


            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            String replymsg = messageReciever.readMessage();
            processMessage(replymsg);

            if (state == RECIEVING) {
                receiverThread = new Thread(this, "Receiver Thread - file id : " + cfd.getFile_id());
                receiverThread.start();
                transferManager.fireFileRecievingStarted(this);
            } else {
                transferManager.fireFileRecievingCannotStart(this);
            }
        } catch (Exception ex) {
            state = CANNOT_START;
            ex.printStackTrace();
        }

    }

    private String getFileDownloadMessage(ClientFileDescriptor cfd) {
        NormalClientDescriptor ncd = cfd.getNormalClientDescriptor();
        Profile profile = ncd.getProfileConnectedWith();

        StringBuilder res = new StringBuilder(50);
        res.append("<con type = \"" + StaticProtocolStrings.STANDARD_TYPE_NAME + "\">");
        res.append("<name>" + XmlSpecChConv.convert(profile.getName()) + "</name>");
        res.append("<password>" + XmlSpecChConv.convert(profile.getPassword()) + "</password>");
        res.append("<files>");
        res.append("<file id =\"" + cfd.getFile_id() + "\"/>");
        res.append("</files>");
        res.append("</con>");
        return res.toString();
    }

    public void pause() {
        paused = true;
    }

    public void continuE() {
        //we must check the state because, the thread can be blocked by I/O operation
        if (state == PAUSED) {
            paused = false;
            receiverThread.interrupt();
            state = RECIEVING;
        }
    }

    public void resume() {

    }

    private void processMessage(String msg) {
        try {
            Document doc = docBuilder.parse(new InputSource(new StringReader(msg)));
            Element root = doc.getDocumentElement();
            String type = root.getAttribute("type");
            if (type.equals("sending")) {
                state = RECIEVING;
            } else if (type.equals(StaticProtocolStrings.TRANSF_RESTRICT)) {
                state = CANNOT_START;
            }

        } catch (SAXException ex) {
            Logger.getLogger(FileReceiver.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(FileReceiver.class.getName()).log(Level.SEVERE, null, ex);
        }

    }

    public void run() {
        try {
            BufferedInputStream bis = new BufferedInputStream(is);
            file = new File(path, cfd.getFileName() + "." + cfd.getExtension());
            getFile().createNewFile();
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(getFile()));

//            int aval,count;
//            int buff;
//
//            while ((buff = bis.read()) != -1) {
//                bos.write(buff);
//                progress++;
//            }

            byte[] buff2 = new byte[BUFFER_SIZE];
            int av;
            while ((av = bis.read(buff2, 0, buff2.length)) != -1) {
                bos.write(buff2, 0, av);
                progress += av;

                while (paused) {
                    try {
                        bos.flush();
                        state = PAUSED;
                        Thread.sleep(1000000);
                    } catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }

                }
            }


            bos.flush();
            bis.close();
            bos.close();
            state = RECIEVE_COMPLETED;
            transferManager.fireFileRecievingCompleted(this);
        } catch (IOException ex) {
            ex.printStackTrace();
            state = INTERRUPTED;
            transferManager.fireFileRecievingIneterrupted(new RecieveInetrruptionEvent(this, ex));
        }
    }

    public long getFileSize() {
        return cfd.getSize();
    }

    public long getProgress() {
        return progress;
    }

    public ClientFileDescriptor getClientFileDescriptor() {
        return cfd;
    }

    public String getState() {
        return state;
    }

    public File getFile() {
        return file;
    }

    @Override
    protected String getMessage(int type) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}
