/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package client.net.transfer;

import common.commun.LineMessageReciever;
import common.commun.LineMessageSender;
import common.commun.MessageReciever;
import common.commun.MessageSender;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 *
 * @author Ati
 */
public abstract class FileTransferer {

    protected MessageSender messageSender;
    protected MessageReciever messageReciever;

    public FileTransferer(InputStream is, OutputStream os) {
        messageSender = new LineMessageSender(os);
        messageReciever = new LineMessageReciever(is);
    }

    protected void sendMessage(final String msg) {
        Thread t = new Thread(new Runnable() {

            public void run() {
                sendMessageHlp(msg);
            }
        });
        t.start();
    }

    protected void sendMessage(int type) {
        sendMessage(getMessage(type));
    }

    private synchronized void sendMessageHlp(final String msg) {
        try {
            messageSender.sendMessage(msg);
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected abstract String getMessage(int type);
}
