package client.net.transfer;

import client.*;
import client.net.commun.ClientManager;
import client.net.ConnectionMediator;
import client.net.ConnectionProvider;
import client.net.commun.NormalClient;
import client.net.commun.NormalClientDescriptor;
import client.net.commun.ServerClient;
import common.XmlSpecChConv;
import common.commun.ConnectionData;
import common.commun.ConnectionHandler;
import common.commun.StaticProtocolStrings;
import exceptions.MyRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class TransferManager implements ConnectionHandler, BridgeTransferHandler {

    private Vector<FileSender> fileSenders = new Vector<FileSender>();
    private Vector<FileReceiver> fileRecievers = new Vector<FileReceiver>();
    private ArrayList<FileSendingStateListener> fileSendingStateListener = new ArrayList<FileSendingStateListener>(1);
    private ArrayList<FileRecievingStateListener> fileRecievingListeners = new ArrayList<FileRecievingStateListener>();
    private InfoProvider infoProvider;
    private MessageDigest messageDiggest;
    private ConnectionProvider connector;
    private TransferMngATPClientProvider clientProv;
    private List<TPTransferWaiterData> tpWaitersData = new ArrayList<TPTransferWaiterData>();

    public TransferManager(InfoProvider infoProvider, TransferMngATPClientProvider cp, ConnectionProvider con) throws NoSuchAlgorithmException {
        this.connector = con;
        this.infoProvider = infoProvider;
        clientProv = cp;
        messageDiggest = MessageDigest.getInstance("SHA-1");
    }

    public void downloadFile(ClientFileDescriptor fd) throws IOException {
        downloadFile(fd, OptionalValueProvider.getDownloadDir());
    }

    public void downloadFile(ClientFileDescriptor fd, String path) throws IOException {
        if (fd.isDirectory()) {
            throw new MyRuntimeException("dir not YET supported");
        }

        for (FileReceiver fr : fileRecievers) {
            if (fr.getState() == FileReceiver.RECIEVING) {
                if (fr.getFile().getPath().equals(path + fd.getFileName()+"."+fd.getExtension())) {
                    System.out.println("okk");
                    throw new NotPossibleDownloadException("File in use.", fd);
                }
            }
        }



        NormalClientDescriptor ncd = fd.getNormalClientDescriptor();
        if (ncd.isPassive() && OptionalValueProvider.isPassive()) {
            ServerClient sc = ncd.getConAssistantServer();
            if (sc == null || sc.getState() == ServerClient.DISCONNECTED_STATE) {
                throw new NotPossibleDownloadException(fd);
            }

            addTPTransferWaiterData(new TPTransferWaiterData(fd, path));
            sc.setBridgeTransferHandler(this);
            sc.requestPtPTransfer(fd);
        } else if (ncd.isPassive() && !OptionalValueProvider.isPassive()) {
            addTPTransferWaiterData(new TPTransferWaiterData(fd, path));
            NormalClient nc = clientProv.getNormalClient(ncd);
            nc.requestATPConnectionForTransfer();
        } else {
            Socket s = connector.connectTo(ncd.getIPAdress(), ncd.getCommunicationPort());
            FileReceiver fr = new FileReceiver(path, fd, s, this);
            fileRecievers.add(fr);
        }

    }

    public void processConnection(ConnectionData data) {
        try {
            Element elem = data.getDoc().getDocumentElement();
            String type = elem.getAttribute("type");

            if (type.equals(StaticProtocolStrings.STANDARD_TYPE_NAME)) {
                String name = elem.getElementsByTagName("name").item(0).getTextContent();
                String password = elem.getElementsByTagName("password").item(0).getTextContent();
                Profile profile = new Profile(name, new String(messageDiggest.digest(password.getBytes())));

                FileSender fs = new FileSender(data.getSocket(), data.getOutputStream(), data.getInputStream(), data.getDoc(), profile, infoProvider, this);
                fileSenders.add(fs);
            } else if (type.equals(StaticProtocolStrings.TOACT_FROM_PASSIVE_TRANS_REPLY)) {
                String id = elem.getElementsByTagName("id").item(0).getTextContent();
                TPTransferWaiterData atpd = retriveTPTransferWaiterData(id);

                FileReceiver fr = new FileReceiver(atpd.getPath(), atpd.getClientFileDescriptor(),
                        data.getSocket(), data.getOutputStream(), data.getInputStream(), this);
                fileRecievers.add(fr);
            } else {
                System.out.println("unhandable connection data");
                data.getSocket().close();
            }

        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void handleTransferAcrossBridge(String host, int port, String id, ServerClient assistant) {
        try {
            String tosend = "<con type = \"" + StaticProtocolStrings.TO_BRIDGE_CONN_TYPE + "\">" +
                    "<pur>" + StaticProtocolStrings.BRIDGE_CON_PURPOSE_TRANS + "</pur>" +
                    "<role>" + StaticProtocolStrings.BRIDGE_CON_ROLE_REQ + "</role>" +
                    "<id>" + XmlSpecChConv.convert(OptionalValueProvider.getClientID()) + "</id>" +
                    "</con>";

            ConnectionMediator cm = new ConnectionMediator(connector, host, port,
                    new String[]{tosend});

            TPTransferWaiterData tpwd = retriveTPTransferWaiterData(id);
            FileReceiver fr = new FileReceiver(tpwd.getPath(), tpwd.getClientFileDescriptor(),
                    cm.getSocket(), cm.getOutputStream(), cm.getInputStream(), this);
            fileRecievers.add(fr);
        } catch (IOException ex) {
            ex.printStackTrace();
            Logger.getLogger(ClientManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private synchronized void addTPTransferWaiterData(TPTransferWaiterData t) {
        tpWaitersData.add(t);
    }

    private synchronized TPTransferWaiterData retriveTPTransferWaiterData(String id) {
        for (TPTransferWaiterData td : tpWaitersData) {
            if (td.getID().equals(id)) {
                return td;
            }

        }
        return null;
    }

    public void addFileRecievingStateListener(FileRecievingStateListener l) {
        fileRecievingListeners.add(l);
    }

    public void removeFileRecievingStateListener(FileRecievingStateListener l) {
        fileRecievingListeners.remove(l);
    }

    public void addFileSendingStateListener(FileSendingStateListener l) {
        fileSendingStateListener.add(l);
    }

    public void removeFileSendingStateListener(FileSendingStateListener l) {
        fileSendingStateListener.remove(l);
    }

    public void fireFileSendingStarted(FileSender fs) {
        for (FileSendingStateListener l : fileSendingStateListener) {
            l.sendingStarted(fs);
        }

    }

    public void fireFileSendingCompleted(FileSender fs) {
        for (FileSendingStateListener l : fileSendingStateListener) {
            l.sendingCompleted(fs);
        }

    }

    public void fireFileSendingInetrrupted(SendInterruptEvent evt) {
        for (FileSendingStateListener l : fileSendingStateListener) {
            l.sendingInterrupted(evt);
        }

    }

    public void fireFileRecievingStarted(FileReceiver f) {
        for (FileRecievingStateListener l : fileRecievingListeners) {
            l.recieveStarted(f);
        }

    }

    public void fireFileRecievingCannotStart(FileReceiver f) {
        for (FileRecievingStateListener l : fileRecievingListeners) {
            l.recieveCannotStart(f);
        }

    }

    public void fireFileRecievingCompleted(FileReceiver f) {
        for (FileRecievingStateListener l : fileRecievingListeners) {
            l.recieveCompleted(f);
        }

    }

    public void fireFileRecievingIneterrupted(RecieveInetrruptionEvent evt) {
        for (FileRecievingStateListener l : fileRecievingListeners) {
            l.recieveIneterrupted(evt);
        }

    }

    public void clearSenders() {
        for (int i = fileSenders.size() - 1; i >=
                0; i--) {
            FileSender fs = fileSenders.get(i);
            if (fs.getState() == FileSender.SEND_COMPLETED || fs.getState() == FileSender.INTERRUPTED) {
                fileSenders.remove(fs);
            }

        }
    }

    public void clearReciever() {
        for (int i = fileRecievers.size() - 1; i >=
                0; i--) {
            FileReceiver fs = fileRecievers.get(i);
            if (fs.getState() == FileReceiver.RECIEVE_COMPLETED || fs.getState() == FileReceiver.INTERRUPTED) {
                fileRecievers.remove(fs);
            }

        }
    }

    public String[] getTypesToHandle() {
        return new String[]{StaticProtocolStrings.STANDARD_TYPE_NAME, StaticProtocolStrings.TOACT_FROM_PASSIVE_TRANS_REPLY};
    }
}
