package server;

import bridge.distrib.BridgeProvider;
import common.commun.ConnectionData;
import common.commun.ConnectionHandler;
import common.commun.StaticProtocolStrings;
import exceptions.ClientConnectionWaiterInitException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;

public class SClientManager implements SClientListener, ConnectionHandler {

    private Vector<SClient> clients = new Vector<SClient>();
    private ArrayList<SClientListener> clientListeners = new ArrayList<SClientListener>();
    private BridgeProvider bridgeProvider;

    public SClientManager() throws ClientConnectionWaiterInitException, ParserConfigurationException {
        this(null);
    }

    public SClientManager(BridgeProvider bp) throws ClientConnectionWaiterInitException, ParserConfigurationException {
        bridgeProvider = bp;
        addClientListener(this);
    }

    //TODO: checking if the client is alredy connected (by id)
    public synchronized void processConnection(ConnectionData data) {
        try {
            Element root = data.getDoc().getDocumentElement();
            String conType = root.getAttribute("type");

            if (conType.equals(StaticProtocolStrings.CONNECT_TO_SERVER)) {
                String name = root.getElementsByTagName("name").item(0).getTextContent();
                String desc = root.getElementsByTagName("description").item(0).getTextContent();

                String isPStr = root.getElementsByTagName("ispassive").item(0).getTextContent();
                boolean isPassive = Boolean.parseBoolean(isPStr);
                long shareAmount = Long.parseLong(root.getElementsByTagName("shareamount").item(0).getTextContent());
                int conPort = Integer.parseInt(root.getElementsByTagName("conport").item(0).getTextContent());
                String id = root.getElementsByTagName("id").item(0).getTextContent();
                SClient client;
                try {
                    client = new SClient(data.getSocket(), data.getInputStream(), this, name, desc, isPassive, shareAmount, conPort, id);
                    fireClientConnected(client);
                } catch (IOException ex) {

                    data.getSocket().close();
                    ex.printStackTrace();
                } catch (ParserConfigurationException ex) {
                    ex.printStackTrace();
                }

            }
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void addClientListener(SClientListener l) {
        clientListeners.add(l);
    }

    public void removeClientListener(SClientListener l) {
        clientListeners.remove(l);
    }

    public void fireClientConnected(SClient c) {
        for (SClientListener l : clientListeners) {
            l.clientConnected(c);
        }
    }

    public void fireClientDisconnected(SClient c) {
        for (SClientListener l : clientListeners) {
            l.clientDisconnected(c);
        }
    }

    public int getConnectedClientNumber() {
        return getClients().size();
    }

    public synchronized Vector<SClient> getClients() {
        return clients;
    }

    public synchronized void clientConnected(SClient c) {
        for (SClient client : clients) {
            client.sendClientConnectedMessage(c);
        }

        getClients().add(c);
    }

    public synchronized void clientDisconnected(SClient c) {
        clients.remove(c);
        for (SClient client : clients) {
            client.sendClientDisconnectedMsg(c.getId());
        }
    }

    public String[] getTypesToHandle() {
        return new String[]{StaticProtocolStrings.CONNECT_TO_SERVER};
    }

    public BridgeProvider getBridgeProvider() {
        return bridgeProvider;
    }
}
