package server;

import common.commun.AbstractConnectionWaiter;
import common.commun.NoHandlerForConnectionTypeException;
import common.commun.TrafficHandler;
import exceptions.ClientConnectionWaiterInitException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class SConnectionWaiter extends AbstractConnectionWaiter {

    private SSLServerSocket waitingSocket;
    private Thread waitingThread;

    public SConnectionWaiter(TrafficHandler h, int port) throws ClientConnectionWaiterInitException {
        super(h);
        try {


            KeyStore ks;
            ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(SMainClass.SCRIPTS_DIR + File.separator + "keystr.jks"), "turtlepassword".toCharArray());
            KeyManagerFactory km = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
            km.init(ks, "turtlestandard".toCharArray());
            SSLContext sslc = SSLContext.getInstance("SSL");
            sslc.init(km.getKeyManagers(), null, null);
            SSLServerSocketFactory sslfactory = sslc.getServerSocketFactory();
            waitingSocket = (SSLServerSocket) sslfactory.createServerSocket(port);

            waitingThread = new Thread(this);
            waitingThread.start();
        } catch (Exception ex) {
            ex.printStackTrace();
            throw new ClientConnectionWaiterInitException(ex);
        }

    }
    public void run() {
        try {
            while (true) {
                try {
                    Socket s = waitingSocket.accept();
                    trafficHandler.processConnection(s);
                } catch (NoHandlerForConnectionTypeException ex) {
                    ex.printStackTrace();
                }
            }
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}
