package server;

import bridge.DefaultBridge;
import common.Toolkit;
import common.commun.TrafficHandler;
import exceptions.ClientConnectionWaiterInitException;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.xml.parsers.ParserConfigurationException;

public class SMainClass {

    public static final boolean EMBEDDED_DB = false;
    public static final String SCRIPTS_DIR = System.getProperty("user.dir") + File.separator + "serverscripts";
    public static final String SERVER_HOME = System.getProperty("user.home") + File.separator + "TurtleServer";
    private static final String DB_DIR = SERVER_HOME + File.separator + "ServerDB";
    private static final String dbSrciptFile = SCRIPTS_DIR + File.separator + "serverDBscript.txt";
    private SClientManager sclientManager;
    private DatabaseManager dataBaseManager;
    private Connection con;
    private TrafficHandler trafficHandler;
    private SConnectionWaiter connectionWaiter;
    private SRoutMatcher routMatcher;
    private SimpleBridgeProvider bridgeProvider;
    private DefaultBridge defaultBridge;

    public SMainClass() throws ClientConnectionWaiterInitException, ParserConfigurationException, ClassNotFoundException, SQLException, IOException {
        // con = createConnection();
        dataBaseManager = new DatabaseManager(con);
        defaultBridge = new DefaultBridge();
        routMatcher = new SRoutMatcher(getBridge());
        bridgeProvider = new SimpleBridgeProvider(Toolkit.getLocalIP(), SOptionalValueProvider.getServerWaitingPort());
        sclientManager = new SClientManager(bridgeProvider);

        trafficHandler = new TrafficHandler();
        trafficHandler.registerConnectionHandler(sclientManager);
        trafficHandler.registerConnectionHandler(routMatcher);

        connectionWaiter = new SConnectionWaiter(trafficHandler, SOptionalValueProvider.getServerWaitingPort());
    }

    private Connection createConnection() throws ClassNotFoundException, SQLException, IOException {
        Connection res = null;
        if (EMBEDDED_DB) {
            try {
                System.setProperty("derby.system.home", DB_DIR);
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
                res = DriverManager.getConnection("jdbc:derby:turtleDB;bootPassword=passtodb;");
            } catch (SQLException ex) {
                ex.printStackTrace();
                if (ex.getSQLState().equals("XJ004")) {
                    res = createDB();
                } else {
                    throw ex;
                }
            }
        } else {
            Class.forName("org.apache.derby.jdbc.ClientDriver");
            res = DriverManager.getConnection("jdbc:derby://localhost:1527/TurteServer", "ati", "taoteking");
        }

        return res;
    }

    private Connection createDB() throws IOException, SQLException {
        Connection res = DriverManager.getConnection("jdbc:derby:turtleDB;create=true;dataEncryption=true;bootPassword=passtodb;");
        Toolkit.executeSQLFromFile(dbSrciptFile, con);
        return res;
    }

    public SClientManager getSClientManager() {
        return sclientManager;
    }

    public void setSClientManager(SClientManager val) {
        this.sclientManager = val;
    }

    public DatabaseManager getDataBaseManager() {
        return dataBaseManager;
    }

    public void setDataBaseManager(DatabaseManager val) {
        this.dataBaseManager = val;
    }

    public SRoutMatcher getRoutMatcher() {
        return routMatcher;
    }

    public DefaultBridge getBridge() {
        return defaultBridge;
    }
}
