package server;

import bridge.Bridge;
import bridge.ConnectionAnswer;
import bridge.ConnectionInvitation;
import bridge.RoutMatcher;
import common.commun.ConnectionData;
import common.commun.ConnectionHandler;
import common.commun.StaticProtocolStrings;
import java.io.IOException;
import org.w3c.dom.Document;

public class SRoutMatcher extends RoutMatcher implements ConnectionHandler {

    public SRoutMatcher(Bridge b) {
        super(b);
    }

    public void processConnection(ConnectionData data) {
        Document doc = data.getDoc();

        try {
            int purpose;
            String purType = doc.getElementsByTagName("pur").item(0).getTextContent();
            if (purType.equals(StaticProtocolStrings.BRIDGE_CON_PURPOSE_COMM)) {
                purpose = ConnectionInvitation.CONNECTION_FOR_COMMUNICATION;
            } else {
                purpose = ConnectionInvitation.CONNECTION_FOR_TRANSFER;
            }

            String id = doc.getElementsByTagName("id").item(0).getTextContent();
            String role = doc.getElementsByTagName("role").item(0).getTextContent();

            if (role.equals(StaticProtocolStrings.BRIDGE_CON_ROLE_REQ)) {
                ConnectionInvitation ci = new ConnectionInvitation(data.getSocket(), data.getInputStream(),
                        data.getSocket().getOutputStream(), purpose, id);
                addConnectionInvitation(ci);
            } else {
                ConnectionAnswer ca = new ConnectionAnswer(data.getSocket(), data.getInputStream(),
                        data.getSocket().getOutputStream(), purpose, id);
                addConnectionAnswer(ca);
            }

        } catch (IOException ex) {
            ex.printStackTrace();
        }


    }

    public String[] getTypesToHandle() {
        return new String[]{StaticProtocolStrings.TO_BRIDGE_CONN_TYPE};
    }
}

