/*
 * clientsTableModel.java
 *
 * Created on 05 August 2007, 17:08
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package server.gui;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import server.SClient;
import server.SClientListener;

/**
 *
 * @author A
 */
public class ClientsTableModel extends AbstractTableModel implements SClientListener  {
    private ArrayList<SClient> clients = new ArrayList<SClient>();
    private String[] columns = new String[]{"Name","Description","Passive","Shared","IP","ID"};
    /** Creates a new instance of clientsTableModel */
    public ClientsTableModel() {
        
    }
    
    public Object getValueAt(int rowIndex, int columnIndex) {
        SClient c = clients.get(rowIndex);
        switch (columnIndex) {
            case 0: return c.getName();
            case 1: return c.getDescription();
            case 2: return c.isPassive();
            case 3: return c.getShareAmount() + " Bytes";
            case 4: return c.getIPAddress();
            case 5: return c.getId();
        }
        return null;
    }
    
    public int getRowCount() {
        return clients.size();
    }
    
    public int getColumnCount() {
        return columns.length;
    }
    
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }
    
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 2 ? Boolean.class : String.class;
    }
    
    public String getColumnName(int column) {
        return columns[column];
    }
    
    
    public void clientDisconnected(SClient c) {
        clients.remove(c);
        fireTableDataChanged();
    }
    
    public void clientConnected(SClient c) {
        clients.add(c);
        fireTableDataChanged();
    }
    
    
}
