/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package server.gui;

import bridge.ConnectionAnswer;
import bridge.ConnectionInvitation;
import bridge.RoutMatcherEvent;
import bridge.RoutMatcherListener;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

/**
 *
 * @author Ati
 */
public class RoutMatcherTableModel extends AbstractTableModel implements RoutMatcherListener {

    private ArrayList<ConnectionInvitation> conInv = new ArrayList<ConnectionInvitation>();
    private ArrayList<ConnectionAnswer> conAns = new ArrayList<ConnectionAnswer>();
    private String[] colNames = new String[]{"Host", "ID", "Purpose", "Type"};
    private static final String FOR_COMMUNICATION = "Communication";
    private static final String FOR_TRANSFER = "Transfer";
    private static final String TYPE_ANS = "Answer";
    private static final String TYPE_REQ = "Request";

    public int getRowCount() {
        return conInv.size() + conAns.size();
    }

    @Override
    public String getColumnName(int column) {
        return colNames[column];
    }

    public int getColumnCount() {
        return colNames.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < conInv.size()) {
            ConnectionInvitation ci = conInv.get(rowIndex);
            switch (columnIndex) {
                case 0:
                    return ci.getSocket().getInetAddress().getHostAddress();
                case 1:
                    return ci.getForeignID();
                case 2:
                    return ci.getConnectionType() == ConnectionInvitation.CONNECTION_FOR_COMMUNICATION
                            ? FOR_COMMUNICATION : FOR_TRANSFER;
                case 3:
                    return TYPE_REQ;
            }
        } else {
            ConnectionAnswer ans = conAns.get(rowIndex - conInv.size());
            switch (columnIndex) {
                case 0:
                    return ans.getSocket().getInetAddress().getHostAddress();
                case 1:
                    return ans.getMyID();
                case 2:
                    return ans.getConnectionType() == ConnectionInvitation.CONNECTION_FOR_COMMUNICATION
                            ? FOR_COMMUNICATION : FOR_TRANSFER;
                case 3:
                    return TYPE_ANS;

            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void ConnectionInvitationAdded(RoutMatcherEvent evt) {
        if (evt.isRoadEstablished()) {
            conAns.remove(evt.getConnectionAnswer());
        } else {
            conInv.add(evt.getConnectionInvitation());
        }
        fireTableDataChanged();
    }

    public void ConnectionAnswerAdded(RoutMatcherEvent evt) {
        if (evt.isRoadEstablished()) {
            conInv.remove(evt.getConnectionInvitation());
        } else {
            conAns.add(evt.getConnectionAnswer());
        }
        fireTableDataChanged();
    }
}
