#include <cstdlib>
#include <stdio.h>
#include <sys/time.h>
#include <random>
typedef unsigned long long ull;

using namespace std;

int hashh(long long x) {
       x = ((x >> 16) ^ x) * 0x45d9f3b;  // 0x3335b369
      x = ((x >> 16) ^ x) * 0x45d9f3b;
      x = ((x >> 16) ^ x);
      return x;//x%224;
}




unsigned long long bases_1[] = {  4449ll, 7617ll, 19304ll, 2317ll, 6901ll, 10614ll, 8095ll, 415ll, 39348ll, 2284ll, 2495ll, 37088ll, 11571ll, 16533ll, 4793ll, 39467ll, 7716ll, 24102ll, 29587ll, 11992ll, 1408ll, 13910ll, 640ll, 518ll, 15859ll, 60189ll, 3590ll, 7311ll, 16684ll, 6237ll, 44999ll, 760ll, 2549ll, 11973ll, 17832ll, 2362ll, 13007ll, 60289ll, 4494ll, 18172ll, 1928ll, 13920ll, 4826ll, 39794ll, 19361ll, 6097ll, 12521ll, 12006ll, 1859ll, 207ll, 12123ll, 846ll, 5559ll, 4475ll, 5154ll, 326ll, 63629ll, 6251ll, 125404ll, 7181ll, 7510ll, 521ll, 2550ll, 305ll, 9375ll, 22163ll, 9953ll, 5143ll, 4256ll, 466ll, 16576ll, 6966ll, 30305ll, 21256ll, 11999ll, 3179ll, 46775ll, 24116ll, 2642ll, 20411ll, 1540ll, 2302ll, 4595ll, 1436ll, 8030ll, 7482ll, 23774ll, 15508ll, 13330ll, 17589ll, 87149ll, 9516ll, 148ll, 124ll, 25355ll, 6811ll, 14255ll, 51320ll, 15056ll, 24151ll, 1426ll, 11592ll, 4561ll, 12444ll, 3197ll, 5314ll, 3506ll, 4544ll, 12367ll, 25522ll, 14564ll, 4699ll, 5574ll, 1676ll, 7524ll, 49311ll, 16257ll, 6999ll, 
325ll,
 112287ll, 886ll, 11489ll, 8802ll, 30584ll, 59752ll, 10462ll, 3900ll, 25817ll, 4688ll, 7526ll, 2229ll, 44913ll, 62628ll, 10638ll, 1124ll, 1516ll, 11074ll, 6189ll, 50255ll, 2964ll, 5350ll, 8749ll, 8967ll, 2755ll, 815ll, 31496ll, 23658ll, 4075ll, 4308ll, 965ll, 3123ll, 2689ll, 3608ll, 12550ll, 531ll, 16079ll, 5539ll, 5516ll, 36058ll, 265ll, 4564ll, 66795ll, 25051ll, 399ll, 5382ll, 26391ll, 3871ll, 1148ll, 6279ll, 32672ll, 56981ll, 19194ll, 26149ll, 3467ll, 1394ll, 31396ll, 53539ll, 5568ll, 1899ll, 36945ll, 24676ll, 9453ll, 65661ll, 98668ll, 559ll, 55081ll, 2030ll, 10324ll, 11975ll, 12257ll, 43829ll, 15111ll, 346ll, 3856ll, 4512ll, 276ll, 3917ll, 32174ll, 11600ll, 849ll, 9492ll, 4710ll, 9428ll, 2911ll, 5889ll, 12336ll, 2637ll, 8123ll, 982ll, 994ll, 1893ll, 11010ll, 10869ll, 14611ll, 1601ll, 8636ll, 602ll, 23466ll, 213ll, 33773ll, 759ll, 5076ll, 2558ll, 2751ll  };

 
unsigned char bases_2[] = { 17, 11, 6, 60, 7, 13, 11, 34, 13, 2, 3, 37, 13, 11, 38, 2, 7, 105, 2, 7, 42, 11, 7, 3, 6, 15, 53, 44, 6, 6, 5, 15, 54, 7, 35, 10, 10, 15, 10, 10, 17, 17, 11, 10, 15, 43, 7, 5, 5, 3, 7, 43, 34, 2, 34, 2, 68, 53, 39, 10, 7, 6, 11, 2, 5, 2, 7, 2, 6, 5, 15, 40, 3, 5, 5, 2, 2, 10, 47, 13, 7, 43, 6, 7, 5, 6, 6, 13, 6, 35, 6, 15, 6, 13, 40, 10, 11, 2, 7, 2, 2, 3, 13, 3, 11, 15, 10, 5, 11, 14, 7, 11, 47, 5, 2, 2, 6, 2, 5, 55, 6, 5, 7, 2, 6, 58, 35, 11, 5, 12, 17, 6, 10, 12, 6, 6, 2, 53, 2, 2, 13, 5, 14, 7, 15, 6, 13, 62, 10, 6, 3, 7, 7, 3, 14, 5, 14, 73, 15, 11, 11, 6, 5, 17, 10, 5, 3, 37, 51, 10, 7, 5, 38, 12, 5, 11, 5, 7, 6, 5, 6, 40, 43, 57, 10, 13, 7, 15, 2, 10, 34, 7, 39, 10, 5, 3, 6, 13, 11, 5, 10, 43, 10, 5, 3, 14, 5, 2, 5, 41, 5, 39, 46, 2, 10, 2, 5, 12, 3, 2, 2, 5, 15, 43, 17, 41, 2, 13, 15, 38, 11, 11, 3, 34, 5, 6, 3, 7, 2, 37, 5, 6, 10, 17, 35, 2, 15, 6, 7, 5, 3, 13, 13, 12, 34, 2, 12, 10, 15, 13, 2, 2, 34, 6, 6, 5, 2, 7, 13, 3, 6, 11, 39, 42, 7, 2, 6, 39, 47, 3, 17, 5, 13,
 7, 2, 47, 3, 7, 6, 11, 17, 37, 48, 7, 37, 11, 7, 10, 3, 14, 39, 14, 15, 43, 17, 2, 12, 7, 13, 5, 3, 6, 34, 37, 3, 17, 13, 2, 5, 10, 10, 44, 37, 2, 2, 10, 10, 7, 3, 7, 2, 7, 5, 43, 43, 11, 15, 51, 13, 17, 10, 11, 2, 5, 34, 17, 2, 2, 42, 6, 6, 5, 47, 15, 2, 12, 7, 3, 10, 15, 3, 7, 12, 12, 15, 43, 14, 7, 58, 13, 10, 6, 6, 38, 34, 5, 5, 13, 38, 6, 11, 10, 6, 7, 2, 55, 2, 13, 5, 11, 44, 15, 17, 2, 40, 2, 15, 13, 6, 2, 3, 3, 3, 3, 6, 39, 5, 11, 17, 37, 5, 7, 6, 10, 6, 12, 7, 5, 14, 10, 12, 71, 10, 35, 6, 11, 3, 2, 38, 3, 2, 34, 10, 17, 42, 2, 12, 6, 6, 11, 40, 12, 10, 6, 10, 2, 3, 3, 56, 11, 7, 42, 2, 38, 12, 2, 2, 13, 40, 12, 6, 5, 5, 59, 15, 38, 5, 5, 5, 7, 2, 10, 7, 2, 17, 10, 11, 6, 6, 6, 2, 10, 6, 54, 2, 82, 3, 34, 14, 15, 44, 5, 46, 2, 13, 5, 12, 13, 11, 10, 39, 5, 40, 3, 60, 3, 42, 11, 3, 46, 17, 3, 2, 37, 6, 42, 12, 14, 3, 12, 66, 13, 34, 7, 3, 13, 3, 11, 2, 13, 12, 38, 34, 5, 40, 10, 14, 6, 14, 11, 38, 58, 2, 48, 5, 15, 5, 73, 3, 37, 5, 11, 10, 5, 5, 13, 2, 10, 13, 34, 17, 3, 7, 47, 2, 2, 10, 15, 3, 3, 
13, 6, 34, 13, 10, 13, 3, 6, 41, 10, 6, 2, 6, 2, 6, 2, 6, 6, 37, 10, 44, 35, 13, 51, 2, 7, 53, 5, 40, 5, 2, 37, 11, 15, 11, 13, 2, 5, 2, 6, 10, 17, 15, 43, 39, 17, 2, 12, 10, 15, 17, 7, 13, 3, 7, 15, 37, 5, 15, 7, 6, 10, 51, 2, 2, 40, 61, 2, 13, 13, 11, 2, 5, 34, 5, 5, 7, 2, 2, 2, 11, 3, 6, 13, 6, 17, 11, 10, 7, 46, 15, 7, 14, 35, 11, 7, 10, 6, 11, 40, 11, 2, 39, 7, 6, 66, 5, 3, 6, 5, 11, 10, 2, 10, 7, 13, 2, 45, 34, 6, 35, 2, 11, 5, 59, 75, 10, 17, 14, 17, 17, 17, 2, 11, 7, 10, 6, 11, 6, 56, 34, 35, 11, 14, 12, 41, 40, 17, 40, 3, 11, 7, 37, 14, 7, 13, 7, 5, 2, 10, 6, 39, 2, 7, 37, 35, 10, 5, 15, 2, 7, 38, 34, 11, 17, 5, 6, 10, 3, 6, 7, 7, 43, 14, 2, 43, 3, 2, 47, 7, 35, 7, 3, 53, 2, 10, 10, 10, 60, 10, 6, 2, 6, 10, 5, 7, 57, 53, 13, 3, 35, 38, 15, 42, 3, 3, 12, 2, 10, 3, 38, 54, 13, 10, 11, 7, 13, 7, 2, 12, 39, 10, 54, 2, 12, 38, 10, 12, 12, 5, 15, 6, 10, 13, 5, 15, 10, 13, 6, 41, 40, 14, 12, 10, 11, 40, 5, 11, 10, 2, 5, 2, 13, 6, 2, 13, 5, 2, 10, 15, 5, 5, 10, 34, 13, 2, 5, 14, 5, 6, 5, 13, 3, 43, 6, 13, 
11, 50, 3, 6, 6, 12, 15, 11, 37, 7, 69, 11, 14, 14, 7, 43, 5, 35, 11, 35, 11, 11, 34, 34, 39, 14, 11, 2, 10, 53, 6, 11, 2, 11, 60, 39, 11, 6, 15, 40, 17, 47, 34, 50, 7, 59, 47, 5, 13, 39, 5, 6, 53, 10, 14, 5, 51, 5, 7, 5, 6, 77, 7, 12, 7, 42, 2, 5, 2, 6, 60, 10, 13, 10, 6, 47, 6, 15, 17, 10, 11, 10, 12, 7, 7, 10, 17, 34, 5, 10, 7, 7, 2, 6, 10, 38, 2, 15, 6, 13, 7, 13, 2, 3, 13, 5, 3, 17, 2, 5, 15, 11, 39, 7, 39, 10, 10, 2, 6, 13, 3, 5, 17, 6, 14, 10, 37, 44, 3, 34, 5, 11, 7, 12, 2, 5, 3, 12, 3, 2, 3, 133, 12, 2, 2, 2, 3, 34, 14, 41, 2, 37, 11, 2, 6, 11, 6, 7, 15, 11, 35, 13, 6, 5, 2, 14, 7, 2 };

unsigned short bases_3[] = { 15591, 2018, 166, 7429, 8064, 16045, 10503, 4399, 1949, 1295,
2776, 3620, 560, 3128, 5212, 2657, 2300, 2021, 4652, 1471, 9336, 4018, 2398,
20462, 10277, 8028, 2213, 6219, 620, 3763, 4852, 5012, 3185, 1333, 6227, 5298,
1074, 2391, 5113, 7061, 803, 1269, 3875, 422, 751, 580, 4729, 10239, 746,
2951, 556, 2206, 3778, 481, 1522, 3476, 481, 2487, 3266, 5633, 488, 3373,
6441, 3344, 17, 15105, 1490, 4154, 2036, 1882, 1813, 467, 3307, 14042, 6371,
658, 1005, 903, 737, 1887, 7447, 1888, 2848, 1784, 7559, 3400, 951, 13969,
4304, 177, 41, 19875, 3110, 13221, 8726, 571, 7043, 6943, 1199, 352, 6435,
165, 1169, 3315, 978, 233, 3003, 2562, 2994, 10587, 10030, 2377, 1902, 5354,
 4447, 1555, 263, 27027, 2283, 305, 669, 1912, 601, 6186, 429, 1930, 14873,
 1784, 1661, 524, 3577, 236, 2360, 6146, 2850, 55637, 1753, 4178, 8466, 222,
 2579, 2743, 2031, 2226, 2276, 374, 2132, 813, 23788, 1610, 4422, 5159, 1725,
 3597, 3366, 14336, 579, 165, 1375, 10018, 12616, 9816, 1371, 536, 1867, 10864,
 857, 2206, 5788, 434, 8085, 17618, 727, 3639, 1595, 4944, 2129, 2029, 8195,
 8344, 6232, 9183, 8126, 1870, 3296, 7455, 8947, 25017, 541, 19115, 368, 566,
 5674, 411, 522, 1027, 8215, 2050, 6544, 10049, 614, 774, 2333, 3007, 35201,
 4706, 1152, 1785, 1028, 1540, 3743, 493, 4474, 2521, 26845, 8354, 864, 18915,
 5465, 2447, 42, 4511, 1660, 166, 1249, 6259, 2553, 304, 272, 7286, 73,
 6554, 899, 2816, 5197, 13330, 7054, 2818, 3199, 811, 922, 350, 7514, 4452,
 3449, 2663, 4708, 418, 1621, 1171, 3471, 88, 11345, 412, 1559, 194 };

 uint out_3[] = { 3277, 514447, 1082401, 1207361, 3581761, 9371251, 25326001, 36338653, 41642681, 48316969, 52204237, 55729957, 69485281, 91433281, 93431521, 158496911, 161304001, 207477001, 208051201, 260518801, 270525737, 284166877, 284301751, 299736181, 337135501, 504870241, 509551201, 725508241, 747406801, 773131927, 840749761, 1154987209, 1157839381, 1356328121, 1362515701, 1397357851, 1421475031, 1425860101, 1465908193, 1532755369u, 1567830241u, 1620646177u, 1844028961u, 1923224689u, 2029830409u, 2055634561u, 2173540951u, 2335341601u, 2474676949u, 2701878941u, 2945208001u, 2994098281u, 3038880473u, 3215031751u, 3275671969u, 3542303047u, 3697278427u, 3874471147u, 3900327241u };

 
/*****************************************************
 * ********** SPRP TEST ******************************
 * ******** a = base ******* n = number *************/

ull pow(ull a,ull e,ull n) {
      ull ans = 1;
      while(e>0) {
	  if(e&1) ans=(ans*a)%n;
	  a=(a*a)%n;
	  e>>=1;
      }
      return ans;
}

//n is odd
int is_SPRP(ull a,ull n) {
      int d=0;
      ull t = n-1;
      while(t%2==0) {
	  ++d;
	  t>>=1;
      }
      ull x = pow(a,t,n);
      if(x==1) return 1; 
      for(int i=0;i<d;++i) {
	  if(x==n-1) return 1;
	  x=(x*x)%n;
	  if(x==1) return 0;
      }
      return 0;
}



/**********************************************************
 * ********M O N T G O M E R Y   R E D U C T I O N ********
 * modified version of http://www.hackersdelight.org/MontgomeryMultiplication.pdf
 * ********************************************************/

void xbinGCD(uint a, uint b, uint *pu, uint *pv)  { 
  uint alpha, beta, u, v; 
  u = 1; v = 0; 
  alpha = a; beta = b; // Note that alpha is 
  // even and beta is odd. 
 
  /* The invariant maintained from here on is: 
  a = u*2*alpha - v*beta. */ 

  while (a > 0) { 
    a = a >> 1; 
    if ((u & 1) == 0) { // Delete a common 
      u = u >> 1; v = v >> 1; // factor of 2 in 
    } // u and v. 
    else { 
      /* We want to set u = (u + beta) >> 1, but 
      that can overflow, so we use Dietz's method. */ 
      u = ((u ^ beta) >> 1) + (u & beta); 
      v = (v >> 1) + alpha; 
    }
  }
 
  *pu = u; 
  *pv = v; 
  return;
}



uint montmul(uint abar, uint bbar, uint m, uint mprime) { 
  ull t = (ull)abar*bbar;
  
  ull tm = t*mprime; // &0xFFFFFFFF
  tm&=0xFFFFFFFF;
  tm = tm*m;
  
  tm = tm+t;
  
  if(tm<t) {
      tm>>=32;
      tm|=1ll<<32;
  }
  else tm>>=32;
  
  if(tm>=m) tm-=m;
  
  return tm;
}

uint mulmodMont(uint baseM,uint e,uint modul,uint pv,uint oneM) {
    uint ans = oneM;
    while(e>0) {
	if(e&1) {
	    ans = montmul(baseM,ans,modul,pv);
	}
	baseM = montmul(baseM,baseM,modul,pv);
	e>>=1;
    }
    return ans;
}


int is_SPRP_mr(uint base,uint modul) {
    if(base>=modul) base = base%modul;
    uint pu,pv;
    xbinGCD(1ull<<31,modul,&pu,&pv);
    uint baseM = (((ull)base)<<32)%modul;
    uint oneM = (1ll<<32)%modul;
    uint moneM = modul - oneM;
    uint e = modul-1;
    while(e%2==0) e>>=1;
    uint t = mulmodMont(baseM,e,modul,pv,oneM);
    if(t==oneM) return 1;
    while(e<modul-1) {
	if(t==moneM) return 1;
	t = montmul(t,t,modul,pv);
	if(t==oneM) return 0;
	e<<=1;
    }
    return 0;
}

/***********************************************
 ************** TESTS **************************
 **********************************************/

int is_prime_1a(uint x) {
    if(x<2) return 0;
    if(x==2 || x==3 || x==5 || x==7) return 1;
    if(x%2==0 || x%3==0 || x%5==0 || x%7==0) return 0;
    if(x<121) return x!=1;
    
    long long t = x;
    t = ((t >> 16) ^ t) * 0x45d9f3b;  // 0x3335b369
    t = ((t >> 16) ^ t) * 0x45d9f3b;
    t = ((t >> 16) ^ t);
    t = t%224;
    return is_SPRP(bases_1[t],(ull)x);
}

int is_prime_1b(uint x) {
    if(x<2) return 0;
    if(x==2 || x==3 || x==5 || x==7) return 1;
    if(x%2==0 || x%3==0 || x%5==0 || x%7==0) return 0;
    if(x<121) return x!=1;
    
    return is_SPRP(bases_2[(((long long)0xAFF7B4*x)>>7)&1023],(ull)x);
}

int is_prime_3(uint x) {
    if(x<2) return 0;
    if(x==2 || x==3 || x==5 || x==7) return 1;
    if(x%2==0 || x%3==0 || x%5==0 || x%7==0) return 0;
    if(x<121) return x!=1;
    
    return is_SPRP(2ull,(ull)x) && is_SPRP(7ull,(ull)x) && is_SPRP(61ull,(ull)x);
}

int is_prime_2(uint x) {
    if(x<2) return 0;
    if(x==2 || x==3 || x==5 || x==7) return 1;
    if(x%2==0 || x%3==0 || x%5==0 || x%7==0) return 0;
    if(x<121) return x!=1;
    if(is_SPRP(2ull,(ull)x)==1 && is_SPRP(15ull,(ull)x)==1) {
	int z=0,k=59;
	while(k-z>1) {
	    int mid = (z+k)/2;
	    if(x<out_3[mid]) k=mid;
	    else z=mid;
	}
	if(out_3[z]==x) return 0;
	else return 1;
	
    }
    else return 0;
}
// is_prime_1b with Montgomery multiplication
int is_prime_5(uint x) {
    if(x<2) return 0;
    if(x==2 || x==3 || x==5 || x==7) return 1;
    if(x%2==0 || x%3==0 || x%5==0 || x%7==0) return 0;
    if(x<121) return x!=1;
    
    return is_SPRP_mr((uint)bases_2[(((long long)0xAFF7B4*x)>>7)&1023],x);
}
    


int main(void) {
    
}