#include <cstdlib>
#include <stdio.h>
using namespace std;

const unsigned long long n = 1ll<<32;
const int buffer_size = 2000000;

typedef unsigned char uch;
typedef unsigned int uint;
typedef unsigned long long ull;

uch *primes;

int prime(long long x) {
    if(x==2) return 1;
    if(x%2==0) return 0;
    long long pos = x/16;
    long long index = (x&15)>>1;
    return (1<<index)&(~(primes[pos]));
}
void eratosten_sieve(void) {
      long long pos;
      long long index;
      for(long long i=3;i*i<n;++i) {
	  if(!prime(i)) continue;
	  for(long long j=i*i;j<n;j+=(i<<1)) {
	      pos = j/16;
	      index = ((j&15)>>1);
	      primes[pos]|=(1<<index);
	  }
      }
}
    
ull pow(ull a,ull e,ull n) {
      ull ans = 1;
      while(e>0) {
	  if(e&1) ans=(ans*a)%n;
	  a=(a*a)%n;
	  e>>=1;
      }
      return ans;
}

//n is odd
int is_SPRP(ull a,ull n) {
      int d=0;
      ull t = n-1;
      while(t%2==0) {
	  ++d;
	  t>>=1;
      }
      ull x = pow(a,t,n);
      if(x==1) return 1; 
      for(int i=0;i<d;++i) {
	  if(x==n-1) return 1;
	  x=(x*x)%n;
      }
      return 0;
}

void write_buffer(uint buffer[],int count, FILE *f) {
    int x = 0;
    while (x<count) {
	int d = fwrite(buffer+x,4,count-x,f);
	x+=d;
    }
    for(int i=0;i<count;++i) buffer[i]=0;
}

void null_buffer(uint buffer[]) {
    for(int i=0;i<buffer_size;++i) buffer[i]=0;
}

int main(int argc, char** argv) {
     uint buffer[buffer_size];
     printf("Building eratosten_sieve\n");
     primes = new uch[(n/16)+1];
     for(long long i=0;i<(n/16)+1;++i) primes[i]=0;
     eratosten_sieve(); 
     printf("Build complete\nSet the range to be computed:\n");
     long long start,end;
     scanf("%lld %lld",&start,&end);
     if(end>n) {
	printf("Warning end point [%lld] is larger then computed primes [%lld]\n",end,n);
	delete[] primes;
	return 0;
     }
     FILE *source,*dest;
     char name[50];
     sprintf(name,"gen_%lld",end);
     printf("Making file %s\n",name);
     dest = fopen64(name,"wb");
     if(start>0) {
	char sname[50];
	sprintf(sname,"gen_%lld",start);
	source = fopen64(sname,"rb");
	while(!feof(source)) {
	    int c = fread(buffer,4,buffer_size,source);
	    int x = 0;
	    while(x<c) { int d = fwrite(buffer+x,4,c-x,dest); x+=d; }
	}
	fclose(source);
     }
     null_buffer(buffer);
     if(start==0) start=121;
     long long buffer_pos = 0;
     if(end==0) end = 1ll<<32;
     printf("Copy done\nGenerating output in range [%lld - %lld]\n",start,end);
     if(start%2==0) ++start;
     for(ull i=start;i<end;i+=2) {
	  if(i%3==0 || i%5==0 || i%7==0 || prime(i)) continue;
	  for(ull j=2;j<34;++j) {
	      //base is viable
	      if(is_SPRP(j,i)==0) buffer[buffer_pos]|=(1<<(j-2));
	  }
	  ++buffer_pos;
	  if(buffer_pos==buffer_size) {
	      //fwrite(buffer,4,buffer_size,dest);
	      write_buffer(buffer,buffer_size,dest);
	      buffer_pos=0;
	  }
     }
     //fwrite(buffer,4,buffer_pos,dest);
     write_buffer(buffer,buffer_pos,dest);
     fclose(dest);
     printf("Generating done\n");
	    /*
     for(int i=121;i<n;i+=2) {
	if(i%131072==1) printf("%d\n",i);
	if(i%3==0 || i%5==0 || i%7==0) continue;
       int h = hash(i);
       int b = 0;
	for(long long j=0;j<100;++j) {
	    if(witness[h][j]==-1) continue;
	    int x = test_prime(j+2,i);
	    if(x==-1) witness[h][j]=-1;
	    else { witness[h][j]+=x; b=1; }
	}
	if(!b) {
	    delete[] primes;
	    printf("IMPOSSIBLE %d\n",h);
	    return 0;
	}
     }
     long long total=0;
     for(int i=0;i<1024;++i) {
        int min=-1;
	for(int j=0;j<100;++j) {
	    if(witness[i][j]==-1) continue;
	    if(min==-1) min = j;
	    witness[i][j]<witness[i][min]?j:min;
	}
	if(witness[i][min]>0) {
	    printf("%d ",min+2);
	    total+=witness[i][min];
	} 
	else printf("0 ");
	
     }
     printf("\ntotal: %lld    average: %f\n",total,(double)total/n);
	    */
     delete[] primes;
       
}