#include <cstdlib>
#include <stdio.h>
#include <vector>
#include <unordered_map>
#include <ctime>
using namespace std;

const unsigned long long n = 1ll<<32;
const int buffer_size = 10000000;
const int hash_SIZE = 448;
const int tolerance = hash_SIZE>>1;
const int hash_count = 25;

time_t current_time;

typedef unsigned char uch;
typedef unsigned int uint;
typedef unsigned long long ull;

uch *primes;
int *hash_table[hash_count][2];

int prime(long long x) {
    if(x==2) return 1;
    if(x%2==0) return 0;
    long long pos = x/16;
    long long index = (x&15)>>1;
    return (1<<index)&(~(primes[pos]));
}
void eratosten_sieve(void) {
      long long pos;
      long long index;
      for(long long i=3;i*i<n;++i) {
	  if(!prime(i)) continue;
	  for(long long j=i*i;j<n;j+=(i<<1)) {
	      pos = j/16;
	      index = ((j&15)>>1);
	      primes[pos]|=(1<<index);
	  }
      }
}
    
ull pow(ull a,ull e,ull n) {
      ull ans = 1;
      while(e>0) {
	  if(e&1) ans=(ans*a)%n;
	  a=(a*a)%n;
	  e>>=1;
      }
      return ans;
}

//n is odd
int is_SPRP(ull a,ull n) {
      int d=0;
      ull t = n-1;
      while(t%2==0) {
	  ++d;
	  t>>=1;
      }
      ull x = pow(a,t,n);
      if(x==1) return 1; 
      for(int i=0;i<d;++i) {
	  if(x==n-1) return 1;
	  x=(x*x)%n;
      }
      return 0;
}

int hashh(uint x,int i) {
    return (hash_table[i][1][x>>16]+hash_table[i][0][x&65535])%hash_SIZE;
}

void read_toBuffer(uint buffer[],FILE *f) {
    fread(buffer,4,buffer_size,f);
}

int find_base(uint x) {
    for(int i=0;i<32;++i) {
	if(x&(1<<i)) return (i+2);
    }
    return 0;
}
void print_base(uint base[]) {
    for(int i=0;i<1024;++i) printf("%d ",base[i]);
    printf("\n");
}
FILE* open_backup(char name[],int task,char par[]) {
    char tmp[50];
    sprintf(tmp,"%s_%d",name,task);
    return fopen64(tmp,par);
}

void print_time() {
    time_t a = time(NULL);
    printf("%d seconds\n",a-current_time);
    current_time = a;
}



int main(int argc, char** argv) {
      int ans[3];
      int tolerance_error = 0;
      for(int i=0;i<3;++i) ans[i]=0;
      int hash_functions[hash_count][32];
      ull bases[hash_count][hash_SIZE][2];
      srand(time(NULL));
      /* TIMES */
      current_time = time(NULL);
      time_t t=time(NULL);
      tm *timeinfo = localtime(&t);
      printf("Started: %02d:%02d:%02d\n",timeinfo->tm_hour,timeinfo->tm_min,timeinfo->tm_sec);
      
      /* GENERATE HASH FUNCTIONS */
      for(int i=0;i<hash_count;++i) {
	  for(int j=0;j<2;++j)
	    hash_table[i][j] = new int[65536];
	  for(int j=0;j<65536;++j) 
	      for(int k=0;k<2;++k)
		  hash_table[i][k][j]=0;
	  for(int j=0;j<32;++j) hash_functions[i][j] = rand()%hash_SIZE;
	  for(int j=0;j<65536;++j) {
	      for(int k=0;k<2;++k) {
		  for(int l=0;l<16;++l) {
		      if((j&(1<<l))!=0) hash_table[i][k][j] = (hash_table[i][k][j]+hash_functions[i][l+k*16])%hash_SIZE;
		  }
	      }
	  }
      }
      printf("GENERATING hash func done in ");
      print_time();
      
      
      /* & BASES FOR hash_count hash func */
      uint *in_buffer = new uint[buffer_size];
      ull *base_buffer = new ull[buffer_size<<1];
      int r;
      for(int i=0;i<hash_count;++i)
	  for(int j=0;j<hash_SIZE;++j)
	      for(int k=0;k<2;++k)
		  bases[i][j][k] = (~0);
	      
      
      FILE *nums = fopen64("numbers.bin","rb");
      FILE *f = fopen64("gen_max","rb");
      do {
	  r = fread(in_buffer,4,buffer_size,nums);
	  fread(base_buffer,8,buffer_size<<1,f);
	  for(int i=0;i<r;++i) {
	      for(int j=0;j<hash_count;++j) {
		  int h = hashh(in_buffer[i],j);
		  for(int k=0;k<2;++k) {
		      bases[j][h][k]&=base_buffer[(i<<1)+k];
		  }
	      }
	  }
	  
      } while(r==buffer_size);
      fclose(f);
      fclose(nums);
      delete[] base_buffer;
      
      printf("& done in ");
      print_time();
      
      
      /* SEARCHING OTHER BASES */
      
      for(int i=0;i<hash_count;++i) {
	  vector<vector<uint> > v;
	  vector<uint> y;
	  unordered_map<int,int> m;
	  bool bellow_64 = true;
	  for(int j=0;j<hash_SIZE;++j) {
	      if(bases[i][j][0]==0ll) {
		  bellow_64 = false;
		  if(bases[i][j][1]==0ll) {
		      v.push_back(y);
		      m[j]=v.size();
		  }
	      }
	  }
	  if(bellow_64) {
	      ++ans[0]; ++ans[1]; ++ans[2];
	      continue;
	  }
	  if(v.size()==0) {
	      ++ans[1]; ++ans[2];
	      continue;
	  }
	  if(v.size() > tolerance) {
	      //printf("size: %d\n",v.size());
	      ++tolerance_error;
	      continue;
	  }
	  
	  printf("HC | B64 | B256 | B1024 | TE\n");
	  printf("%3d %4d %5d %6d %7d\n",hash_count,ans[0],ans[1],ans[2],tolerance_error);
	  
	  /* SEARCHING REMAINING BASES */
	  //printf("%d reading numbers.bin\n",i);
	  nums = fopen64("numbers.bin","rb");
	  r=0;
	  do {
	      r = fread(in_buffer,4,buffer_size,nums);
	      for(int j=0;j<r;++j) {
		  int h = hashh(in_buffer[j],i);
		  if(m[h]>0) {
		    v[m[h]-1].push_back(in_buffer[j]);
		  }
	      }
	  } while(r==buffer_size);
	  fclose(nums);
	  
	  /* ITERATING VECTOR */
	  //printf("%d searching bases %d\n",i,v.size());
	  ull min_base = 130;
	  ull max_base = 258;
	  for(int x = 0;x<2;++x) {
	      bool global_sol = true;
	      for(int j=0;j<v.size();++j) {
		  //printf("%d %d\n",j,v[j].size());
		  if(bases[i][hashh(v[j][0],i)][0]>0) continue;
		  bool local_sol = false;
		  for(ull b = min_base;b<max_base;++b) {
		      bool base_ok = true;
		      for(int k=0;k<v[j].size();++k) {
			  if(is_SPRP(b,(ull)v[j][k])!=0) {
			      base_ok = false;
			      break;
			  }
		      }
		      if(base_ok) {
			  bases[i][hashh(v[j][0],i)][0] = 1;
			  local_sol = true;
			  break;
		      }
		  }
		  if(local_sol==false) {
		      global_sol = false;
		      if(x==1) break;
		  }
	      }
	      if(global_sol) {
		  for(int y=x;y<2;++y) ++ans[y+1];
		  break;
	      }
	      min_base = max_base;
	      max_base = 1026;
	  }
	  printf("done %d: ",i);
	  print_time();
	  printf("HC | B64 | B256 | B1024 | TE\n");
	  printf("%3d %4d %5d %6d %7d\n",hash_count,ans[0],ans[1],ans[2],tolerance_error);
      }
      /* DEALLOC */
      for(int i=0;i<hash_count;++i) 
	  for(int j=0;j<2;++j) delete[] hash_table[i][j];
      delete[] in_buffer;
		     
      /* RESULTS */
      printf("HC | B64 | B256 | B1024 | TE\n");
      printf("%3d %4d %5d %6d %7d\n",hash_count,ans[0],ans[1],ans[2],tolerance_error);
      
      /* TIMES */
      time_t nt = time(NULL);
      timeinfo = localtime(&nt);
      printf("Ended: %02d:%02d:%02d\n",timeinfo->tm_hour,timeinfo->tm_min,timeinfo->tm_sec);
      t=time(NULL)-t; printf("\n(%ld seconds)\n",t);
  
}