#include <cstdlib>
#include <stdio.h>
#include <vector>
#include <unordered_map>
using namespace std;

const unsigned long long n = 1ll<<32;
const int buffer_size = 2000000;
const int tolerance = 350;
int max_base = 35;

typedef unsigned char uch;
typedef unsigned int uint;
typedef unsigned long long ull;

uch *primes;

int prime(long long x) {
    if(x==2) return 1;
    if(x%2==0) return 0;
    long long pos = x/16;
    long long index = (x&15)>>1;
    return (1<<index)&(~(primes[pos]));
}
void eratosten_sieve(void) {
      long long pos;
      long long index;
      for(long long i=3;i*i<n;++i) {
	  if(!prime(i)) continue;
	  for(long long j=i*i;j<n;j+=(i<<1)) {
	      pos = j/16;
	      index = ((j&15)>>1);
	      primes[pos]|=(1<<index);
	  }
      }
}
    
ull pow(ull a,ull e,ull n) {
      ull ans = 1;
      while(e>0) {
	  if(e&1) ans=(ans*a)%n;
	  a=(a*a)%n;
	  e>>=1;
      }
      return ans;
}

//n is odd
int is_SPRP(ull a,ull n) {
      int d=0;
      ull t = n-1;
      while(t%2==0) {
	  ++d;
	  t>>=1;
      }
      ull x = pow(a,t,n);
      if(x==1) return 1; 
      for(int i=0;i<d;++i) {
	  if(x==n-1) return 1;
	  x=(x*x)%n;
      }
      return 0;
}

int hashh(uint x) {
    return (x>>1)&255;
    //return (x>>1)&1023;
    //return (((long long)0xAFF7B4*x)>>7)&1023;
}

void read_toBuffer(uint buffer[],FILE *f) {
    fread(buffer,4,buffer_size,f);
}

int find_base(uint x) {
    for(int i=0;i<32;++i) {
	if(x&(1<<i)) return (i+2);
    }
    return 0;
}
void print_base(uint base[]) {
    for(int i=0;i<1024;++i) printf("%d ",base[i]);
    printf("\n");
}
FILE* open_backup(char name[],int task,char par[]) {
    char tmp[50];
    sprintf(tmp,"%s_%d",name,task);
    return fopen64(tmp,par);
}



int main(int argc, char** argv) {
      if(argc!=3) return 0;
      FILE *f;
      int task = atoi(argv[2]);
      if(task<2) {
	  printf("Loading primes\n");
	  primes = new uch[(n/16)+1];
	  for(long long i=0;i<(n/16)+1;++i) primes[i]=0;
	  f = fopen64("primes.bin","rb");
	  int l = (n/16)+1;
	  if(f==NULL) {
	      printf("File primes.bin not found. Creating primes.bin\n");    
	      eratosten_sieve(); 
	      f = fopen64("primes.bin","wb");
	      int written = 0;
	      while(written<l) {
		  written+=fwrite(primes,1,l,f);
	      }
	      fclose(f);
	      printf("primes.bin created.\n");
	  }
	  else {
	      fread(primes,1,l,f);
	      fclose(f);
	  }
	  printf("primes loaded\n");
     }
     int count=0;
     for(long long i=121;i<(1ll<<32);i+=2) {
	if(i%3==0 || i%5==0 || i%7==0 || prime(i)) continue;
	if(is_SPRP(2ull,(ull)i)==1 && is_SPRP(15ull,(ull)i)==1) {
	    printf("%lld, ",i);
	    ++count;
	}
     }
     printf("\ncount: %d\n",count);
     return 0;
     
     
     
     uint buffer[buffer_size];
     uint bases[1024];
     for(int i=0;i<1024;++i) bases[i]=0xFFFFFFFF;
     if(task<1) {
	printf("Task 1\n");
	f = fopen64("gen_0","rb");
	long long buffer_pos = 0;
	fread(buffer,4,buffer_size,f);
	for(long long i=121;i<n;i+=2) {
	    if(i%3==0 || i%5==0 || i%7==0 || prime(i)) continue;
	    bases[hashh(i)]&=buffer[buffer_pos++];
	    if(buffer_pos==buffer_size) {
		fread(buffer,4,buffer_size,f);
		buffer_pos=0;
	    }		
	}
	fclose(f);
	f = open_backup(argv[1],1,"wb");
	fwrite(bases,4,1024,f);
	fclose(f);
	printf("bakcup %s_1 created\n",argv[1]);
     }
     if(task==1) {
	f = open_backup(argv[1],1,"rb");
	fread(bases,4,1024,f);
	fclose(f);
	printf("Loaded from backup %s_1\n",argv[1]);
     }
     vector<vector<uint> > v;
     vector<uint> y;
     unordered_map<int,int> m;
     if(task<2) {
	for(int i=0;i<1024;++i) {
	    if(bases[i]==0) {
		v.push_back(y);
		m[i]=v.size();
	    }
	    bases[i] = find_base(bases[i]);
	}
	if(v.size() > tolerance) {
	    printf("%d hash have undef. base. Tolerance %d. Exiting\n",v.size(),tolerance);
	    delete[] primes;
	    return 0;
	}
	if(v.size()>0) {
	    printf("Searching remaining %d bases\n",v.size());
	    printf("Scanning\n");
	    for(ull i = 121; i<n;i+=2) {
		if(i%3==0 || i%5==0 || i%7==0 || prime(i)) continue;
		if(m[hashh(i)]>0) {
		    v[m[hashh(i)]-1].push_back((uint)i);
		}
	    }
	}
	else {
	    print_base(bases);
	    delete[] primes;
	    return 0;
	}
	delete[] primes;
    }
    int min_base = 34;
    if(task==2) {
	f = open_backup(argv[1],2,"rb");
	fread(bases,4,1024,f);
	for(int i=0;i<1024;++i) {
	    if(bases[i]==0) {
		int *l = new int;
		fread(l,4,1,f);
		v.push_back(y);
		m[i]=v.size();
		uint *p = new uint[*l];
		fread(p,4,*l,f);
		v[v.size()-1].assign(p,p+(*l));
		delete[] p;
		delete l;
	    }
	}
	fread((int*)(&min_base),4,1,f);
	fclose(f);
	printf("Loaded from backup %s_2\nmin_base: %d\nSet the max_base: ",argv[1],min_base);
	scanf("%d",&max_base);
    }
    long long co = 0;
    for(int i=0;i<v.size();++i) co+=v[i].size();
    printf("Computing bases for remaining %lld nums in %d hash classes\n",co,v.size());
    int undef_bases = 0;
    for(int i=0;i<v.size();++i) {
	    //printf("%d\n",i);
	    int c=0;
	    for(ull j=min_base;j<max_base;++j) {
		int b = 1;
		for(int k=0;k<v[i].size();++k) {
		    if(is_SPRP(j,(ull)v[i][k])!=0) {
			b=0;
			break;
		    }
		}
		if(b==1) {
		    bases[hashh(v[i][0])]=j;
		    c=1;
		    break;
		}
	    }
	    if(c==0) { ++undef_bases; }
    }
    if(undef_bases==0) print_base(bases);
    else {
	printf("%d hash classes are undef.\nCreating backup\n",undef_bases);
	f = open_backup(argv[1],2,"wb");
	fwrite(bases,4,1024,f);
	for(int i=0;i<1024;++i) {
	    if(bases[i]==0) {
		int s = v[m[i]-1].size();
		fwrite((int*)(&s),4,1,f);
		uint *p = v[m[i]-1].data();
		fwrite(p,4,s,f);
	    }
	}
	fwrite((int*)(&max_base),4,1,f);
	fclose(f);
    }       
}