<?php
  class cCourse
  {
    private $db;
    private $id;
    private $bIsLoaded;
    
    private $name;
    private $code;
    private $description;
    private $teacher;
    
    function __construct( $id, $db )
    {
      $this->id = $id;
      $this->db = $db;
      $this->bIsLoaded = false;
      
      if ( $this->id > 0 )
      {
        $query = "SELECT * FROM tCourse WHERE id=".$this->id.";";
        $result = $this->db->QueryToRow($query);
        
        if ( $result != 0 )
        {
          $this->name = $result["name"];
          $this->code = $result["code"];
          $this->description = $result["description"];
          $this->bIsLoaded = true;
        }
      }
    }
    
    function IsLoaded()
    {
      return $this->bIsLoaded;
    }
    
    function LoadByName( $name, &$error )
    {
      $this->id = 0;
      $this->name = "";
      $this->code = "";
      $this->description = "";
      $this->teacher = NULL;
      $this->bIsLoaded = false;

      $query = "SELECT * FROM tCourse WHERE name='".$name."';";
      $result = $this->db->QueryToRow($query);
      if ( $this->db->IsError() )
      {
        $error = $this->db->GetError();
        return false;
      }
           
      if ( $result != 0 )
      {
        $this->id = $result["id"];
        $this->name = $result["name"];
        $this->code = $result["code"];
        $this->description = $result["description"];
        $this->bIsLoaded = true;
      }
      return $this->bIsLoaded;
    }
    
    
    function DBCreate($values, &$error)
    {
      $query = "INSERT INTO tCourse VALUES (0, 0, 0, '".$values["course"]["name"]."', ".
               "'".$values["course"]["code"]."', '".$values["course"]["description"]."', 0, 0);";

      $result = $this->db->Query($query);
      if ( $result == false )
      {
        if ( $this->db->IsError() )
          $error = $this->db->GetError();
        else
          $error = "Chyba pri vytváraní predmetu!";
        return false;
      }     
      $this->id = $this->db->InsertID();
      $this->name = $values["course"]["name"];
      $this->description = $values["course"]["description"];
      
      $query = "INSERT INTO tCourseToUser VALUES (".$this->id.", 0);";
      if ( !$this->db->Query($query) )
      {
      	$error = $this->db->GetError();
      	return false;
      } 

      
      if ( empty( $values["users"] ) )
        return true;                     
        
      foreach ( $values["users"] as $userID )
      {
        $query = "INSERT INTO tCourseToUser VALUES (".$this->id.", ".$userID.");";
        $result = $this->db->Query($query);
        if ( $result == false )
        {
          if ( $this->db->IsError() )
            $error = $this->db->GetError();
          else
            $error = "Chyba pri pridávaní užívateľa k predmetu!";
          return false;
        }             
      }
      return true;
    }
    
    function DBEdit($values, &$error)
    {
      $i = 0;       
      $query = "UPDATE tCourse SET ";
      
      foreach ( $values["course"] as $key => $value )
      {
        $query .= $key."='".$value."'";
        if ( ++$i < count($values["course"]) )
          $query .= ", ";
      }        
      $query .= " WHERE id=".$this->id.";";
      
      $result = $this->db->Query($query);   
      if ( $result == false )
      {
        if ( $this->db->IsError() )
          $error = $this->db->GetError();
        else
          $error = "Chyba pri editovaní predmetu!";
        return false;       
      }
      $this->name = $values["course"]["name"];      
      $this->code = $values["course"]["code"];      
      $this->description = $values["course"]["description"];      
      return true;
    }
    
    function DBDelete( &$error )
    {
      $query = "DELETE FROM tCourse WHERE id=".$this->id.";";
      $result = $this->db->Query($query);
      
      if ( $result )
      {
        $query = "DELETE FROM tCourseToUser WHERE id_course=".$this->id.";";
        $result = $this->db->Query($query);
      }
      
      if ( !$result )
      {
        if ( $this->db->IsError() )
          $error = $this->db->GetError();
        else
          $error = "Chyba pri vymazávaní predmetu!";
        return false;       
      }
      $this->bIsLoaded = false;
      $this->id = 0;
      $this->name = "";
      $this->code = "";
      $this->description = "";
      $this->teacher = NULL;
      $error = "";
      return true;
    }
    
    function DBChangeTeacher($teacherID, &$error)
    {
      $query = "";
      
      if ( !$this->teacher )
        $this->teacher = $this->GetTeacher($error);
        
      if ( !empty($error) )
        return NULL;
      
      if ( $this->teacher && $this->teacher->GetID() == $teacherID )
        return $this->teacher;
        
      $oldTeacherID = $this->teacher ? $this->teacher->GetID() : 0;
      
      $query = "UPDATE tCourseToUser SET id_user=".$teacherID." WHERE ".
               "id_user=".$oldTeacherID." AND id_course=".$this->id.";";
               
      $result = $this->db->Query($query);
      if ( $result == false )
      {
        if ( $this->db->IsError() )
          $error = $this->db->GetError();
        else
          $error = "Chyba pri menení učiteľa!";
        return NULL;       
      }
      if ( $teacherID > 0 )
        $this->teacher = new cTeacher($teacherID, $this->db);
      return $this->teacher;
    }
    
    function GetTeacher(&$error)
    {
      if ( $this->teacher )
        return $this->teacher;
        
      $query = "SELECT u.id AS id FROM tUser AS u, tCourseToUser AS cu, tTeachers AS t ".
               "WHERE cu.id_course=".$this->id." AND u.id=cu.id_user AND cu.id_user=t.id;";
               
      $result = $this->db->QueryToRow($query);
      if ( $result != 0 )
      {
        $this->teacher = new cTeacher($result["id"], $this->db); 
        return $this->teacher;
      }

      if ( $this->db->IsError() )
        $error = $this->db->GetError();
        
      return NULL;
    }
    
    function GetStudents(&$error)
    {
      $students = array();
      $query = "SELECT u.id AS id FROM tUser AS u, tCourseToUser AS cu, tStudents AS s ".
               "WHERE cu.id_course=".$this->id." AND u.id=cu.id_user AND cu.id_user=s.id AND s.bkp=0;";

      $result = $this->db->QueryToArray($query);
      if ( $this->db->IsError() )
      {
        $error = $this->db->GetError();
        return NULL;
      }
      
      for ( $i = 0; $i < count($result); $i++ )
        $students[$i] = new cStudent($result[$i]["id"], $this->db);
        
      return $students;
    }
    
    function GetProperties()
    {
      $result = array();
      $result["id"] = $this->id;
      $result["name"] = $this->name;
      $result["code"] = $this->code;
      $result["description"] = $this->description;
      return $result;
    }    
    
    function GetID()
    {
      return $this->id;
    }
  }
?>
