<?php
  class cSpecialization
  {
    private $db;
    private $id;
    private $bIsLoaded;
    
    private $name;
    private $garant;
    
    function __construct( $id, $db )
    {
      $this->id = $id;
      $this->db = $db;
      $this->bIsLoaded = false;

      if ( $this->id > 0 )
      {
        $query = "SELECT * FROM tSpecialization WHERE id=".$this->id.";";
        $result = $this->db->QueryToRow($query);
        
        if ( $result != 0 )
        {
          $this->name = $result["name"];
          $this->bIsLoaded = true;
        }
      }
    }
    
    function IsLoaded()
    {
      return $this->bIsLoaded;
    }
    
    function LoadByName( $name, &$error )
    {
      $this->id = 0;
      $this->name = "";
      $this->garant = NULL;
      $this->bIsLoaded = false;

      $query = "SELECT * FROM tSpecialization WHERE name='".$name."';";
      $result = $this->db->QueryToRow($query);
      if ( $this->db->IsError() )
      {
        $error = $this->db->GetError();
        return false;
      }
           
      if ( $result != 0 )
      {
        $this->id = $result["id"];
        $this->name = $result["name"];
        $this->bIsLoaded = true;
      }
      return $this->bIsLoaded;
    }
    
    
    function DBCreate($values, &$error)
    {
      $query = "INSERT INTO tSpecialization VALUES (0, '".$values["name"]."', ".$values["id_garant"].");";
      $result = $this->db->Query($query);
      if ( $result == false )
      {
        if ( $this->db->IsError() )
          $error = $this->db->GetError();
        else
          $error = "Chyba pri vytváraní odboru!";
        return false;
      }     
      $this->id = $this->db->InsertID();
      $this->name = $values["name"];
      return true;
    }
    
    function DBEdit($values, &$error)
    {
      $i = 0;       
      $query = "UPDATE tSpecialization SET ";
      
      foreach ( $values as $key => $value )
      {
        $query .= $key."='".$value."'";
        if ( ++$i < count($values) )
          $query .= ", ";
      }        
      $query .= " WHERE id=".$this->id.";";
      
      $result = $this->db->Query($query);   
      if ( $result == false )
      {
        if ( $this->db->IsError() )
          $error = $this->db->GetError();
        else
          $error = "Chyba pri editovaní odboru!";
        return false;       
      }
      $this->name = $values["name"];      
      return ($this->DBChangeGarant( $values["id_garant"], $error ) != NULL);      
    }
    
    function DBDelete( &$error )
    {
      $query = "DELETE FROM tSpecialization WHERE id=".$this->id.";";
      $result = $this->db->Query($query);
      
      if ( $result )
      {
        $query = "UPDATE tStudents SET id_specialization=0 WHERE id_specialization=".$this->id.";";
        $result = $this->db->Query($query);
      }
      
      if ( !$result )
      {
        if ( $this->db->IsError() )
          $error = $this->db->GetError();
        else
          $error = "Chyba pri vymazávaní odboru!";
        return false;       
      }
      $this->bIsLoaded = false;
      $this->id = 0;
      $this->name = "";
      $this->garant = NULL;
      $error = "";
      return true;
    }
    
    function DBChangeGarant($garantID, &$error)
    {
      $query = "";
      
      if ( !$this->garant )
        $this->garant = $this->GetGarant($error);
        
      if ( !empty($error) )
        return NULL;
      
      if ( $this->garant->Loaded() && $this->garant->GetID() == $garantID )
        return $this->garant;
      else
        $query = "UPDATE tSpecialization SET id_garant=".$garantID." WHERE id=".$this->id.";";        
        
      $result = $this->db->Query($query);
      if ( $result == false )
      {
        if ( $this->db->IsError() )
          $error = $this->db->GetError();
        else
          $error = "Chyba pri menení garanta odboru!";
        return NULL;       
      }
      $this->garant = new cTeacher($garantID, $this->db);
      return $this->garant;
    }
    
    function GetGarant(&$error)
    {
      if ( $this->garant )
        return $this->garant;
        
      $query = "SELECT id_garant FROM tSpecialization WHERE id=".$this->id.";";
               
      $result = $this->db->QueryToRow($query);
      if ( $result != 0 )
      {
        $this->garant = new cTeacher($result["id_garant"], $this->db);
        return $this->garant;
      }

      if ( $this->db->IsError() )
        $error = $this->db->GetError();
        
      return NULL;
    }
    
    function GetStudentsByYear( $year, &$error )
    {
      $studentList = NULL;
      $query = "SELECT id FROM tStudents WHERE id_specialization=".$this->id." AND bkp=0"; 
      if ( $year > 0 )
        $query .= " AND year=".$year.";";
      
      $result = $this->db->QueryToArray($query);
      $error = $this->db->GetError();
      if ( $result )
      {
        foreach ( $result as $student )
        {
          $student = new cStudent( $student["id"], $this->db );
          if ( $student )
            $studentList[count($studentList)] = $student->GetProperties();
        }        
      }
      return $studentList;
    }
    
    function GetProperties()
    {
      $result = array();
      $result["id"] = $this->id;
      $result["name"] = $this->name;
      return $result;
    }    
    
    function GetID()
    {
      return $this->id;
    }
  }
?>
