<?php
	class cTeacherPage extends cUsersPage
	{ 
    function __construct( $smarty, $db, $action, $post, $get )
    {
      parent::__construct( $smarty, $db, $action, $post, $get );      
      $this->menuItem = $this->menu->GetItemByLabel("Učitelia");            
      $this->menuItem->bSelected = true;
      $this->menuItem->bExpanded = true;
      $this->exchgManager = new cExchangeManager($this->db);
      
      if ( !empty($this->getParams["id"]) )
        $this->user = new cTeacher($this->getParams["id"], $this->db);        
    }
    
    protected function VerifyUserValues(&$userValues, &$error)
    {
      if ( parent::VerifyUserValues($userValues, $error) )
      {      
        if ( strlen($this->postParams["isic"]) != 10 )
        {
          $this->smarty->assign("error", "Musíte zadať správne číslo ITIC!" );
          return false;
        }
          
        $tempTeacher = new cTeacher(0, $this->db);
        if ( $tempTeacher->LoadByISIC($this->postParams["isic"], $error) &&
             !($this->user && $this->user->GetISIC() == $this->postParams["isic"]) )
        {
          $this->smarty->assign("error", "Učiteľ rovnakým ISIC číslom už existuje!");
          return false;
        }
        return empty( $error );         
      }
      return false;
    }
    
    private function AddUser(&$error)
    {
      if ( $this->VerifyUserValues($userValues, $error) )
      {
        $this->user = new cTeacher(0, $this->db);        
        $userValues["password"] = substr( $userValues["ISIC"], 6, 4 );
        return $this->user->DBCreate( $userValues, $error );
      }
      return false;
    }
    
    private function EditUser(&$error)
    {
      if ( $this->VerifyUserValues($userValues, $error) )
        return $this->user->DBEdit($userValues, $error);

      return false;
    }
    
    private function GetItemList( $userType, $order )
    {
      $userList = array();
      
      $firstChar = "";
      $numIndexes = 0;
      
      $query = "SELECT * FROM tUser as u, tTeachers as t WHERE u.id=t.id";
      
      if ( $order == "nameD" )
        $query .= " ORDER BY u.surname DESC";                      
      else if ( $order == "itic" )
        $query .= " ORDER BY u.isic";                      
      else if ( $order == "iticD" )
        $query .= " ORDER BY u.isic DESC";
      else                     
        $query .= " ORDER BY u.surname";                      
        
      $result = $this->db->QueryToArray($query);
      if ( $result != 0 )
      {
        foreach ( $result as $value )
        {
          $teacher = new cTeacher($value["id"], $this->db);
          if ( $teacher->Loaded() )
            $userList[$value["id"]] = $teacher->GetProperties();
        }
      }
      $this->smarty->assign("teacherCount", count($userList) );
      $this->smarty->assign("order", $order);
      return $userList;      
    }
    
    private function SearchResult(&$error)
    {
      $bCondEmpty = true;
      $c1 = "";
      $c2 = "";
      $c3 = "";
      $c4 = "";
       
      if ( !empty( $this->postParams["login"] ) )
      {
        $c1 .= "u.login LIKE '".$this->postParams["login"]."%'";
        $bCondEmpty = false;
      }
      if ( !empty($this->postParams["name"]) )
      {
        $c2 .= ($bCondEmpty ? "" : " AND")." u.name LIKE '".$this->postParams["name"]."%'";
        $bCondEmpty = false;
      } 
      if ( !empty($this->postParams["surname"]) )
      {
        $c3 .= ($bCondEmpty ? "" : " AND")." u.surname LIKE '".$this->postParams["surname"]."%'";
        $bCondEmpty = false;
      } 
      if ( !empty($this->postParams["isic"]) )
      {
        $c4 = ($bCondEmpty ? "" : " AND")." u.ISIC LIKE '".$this->postParams["isic"]."%'";
        $bCondEmpty = false;
      }
      if ( $bCondEmpty )
        return false;
        
      $query .= sprintf("SELECT u.id AS id FROM tUser AS u, tTeachers AS s WHERE %s%s%s%s".
                        " AND s.id=u.id;", $c1, $c2, $c3, $c4 );                        
      
      $result = $this->db->QueryToArray($query);
      if ( $this->db->IsError() )
      {
        $error = $this->db->GetError();
        return false;
      }            
      
      $users = array();
      for ( $i = 0; $i < count( $result ); $i++ )
      {
        $user = new cTeacher($result[$i]["id"], $this->db);
        if ( !empty( $error ) )
          return false;
          
        if ( $user->Loaded() )
          $users[$i] = $user->GetProperties();
      }
      $this->smarty->assign("userCount",count($users));      
      usort($users, "CmpUsers");
      $this->smarty->assign("users",  $users);
      return true;
    }
		
    function Process()
    {
      switch ( $this->action )
      {
        case "do_add":
          if ( $this->AddUser($this->error) )
          {
            if ( $this->GetUserInfo($this->error) )
            {
              $this->smarty->assign("actionInfo", "Učiteľ bol úspešne pridaný.");
              $this->bPageSet = true;
              break;
            }
            else if ( !empty($this->error) )
              return false;
          }
          else
          {
            if ( !empty( $this->error ) )
              return false;
            $this->action = "add";            
          }
        //fallthrough
        case "add":
          $this->smarty->assign("nPrefixV", $this->postParams["nPrefix"]);
          $this->smarty->assign("nameV", $this->postParams["name"]);
          $this->smarty->assign("surnameV", $this->postParams["surname"]);
          $this->smarty->assign("nSuffixV", $this->postParams["nSuffix"]);
          $this->smarty->assign("isicV", $this->postParams["isic"]);
          $this->smarty->assign("formUrlSuffix", "&amp;action=do_add");
          $this->smarty->assign("buttonLabel","Pridať");
          $subMItem = $this->menuItem->GetItemByLabel("Pridať");
          $this->bPageSet = true;
        break;
        
        case "remove_course":
          if ( $this->RemoveCourse($this->error) )
          {
            if ( empty($this->error) && $this->GetUserInfo($this->error) )
              $this->bPageSet = true;
          }
          if ( !empty($this->error) )
            return false;
        break;
        
        case "do_edit":
          if ( !$this->user )
            break;
            
          if ( $this->EditUser($error) == false )
          {
            $this->action = "edit";
            $this->smarty->assign("nPrefixV", $this->postParams["nPrefix"]);
            $this->smarty->assign("nameV", $this->postParams["name"]);
            $this->smarty->assign("surnameV", $this->postParams["surname"]);
            $this->smarty->assign("nSuffixV", $this->postParams["nSuffix"]);
            $this->smarty->assign("isicV", $this->postParams["isic"]);
            $this->smarty->assign("formUrlSuffix", "&action=do_edit&id=".$this->getParams["id"]);
            $this->smarty->assign("buttonLabel","Editovať");
            $this->smarty->assign("user", $this->user->GetProperties() );
          }
          else
          {
            $this->GetUserInfo($this->error);
            if ( !empty($this->error) )
              return false;
          }
          $this->bPageSet = true;
        break;
        
        case "edit":          
          if ( $this->user )
          {
            $userValues = $this->user->GetProperties();
            $this->smarty->assign("nPrefixV", $userValues["namePrefix"]);
            $this->smarty->assign("nameV", $userValues["name"]);
            $this->smarty->assign("surnameV", $userValues["surname"]);
            $this->smarty->assign("nSuffixV", $userValues["nameSuffix"]);
            $this->smarty->assign("isicV", $userValues["ISIC"]);
            $this->smarty->assign("user", $this->user->GetProperties() );
            $this->smarty->assign("formUrlSuffix", "&action=do_edit&id=".$this->getParams["id"]);
            $this->smarty->assign("buttonLabel","Editovať");
            $this->bPageSet = true;
          }     
        break;
        
        case "do_delete":
          if ( !$this->user )
            break;
            
          if ( $this->user->DBDelete($error) )
            $this->smarty->assign("actionInfo", "Učiteľ bol vymazaný z databázy.");
          else
            $this->smarty->assign("actionInfo", "Chyba pri vymazávaní: ".$error);
        break; 
        
        case "delete":
          if ( $this->user )
          {
            $this->smarty->assign("user", $this->user->GetProperties() );
            $this->bPageSet = true;          	
          }
        break;

        case "search_f":
          $subMItem = $this->menuItem->GetItemByLabel("Vyhľadať");
          $this->bPageSet = true;
        break;
        
        case "do_search":
          if ( $this->SearchResult($this->error) )
            $this->bPageSet = true;
          else if ( !empty( $this->error ) )
            return false;            
        break;
        
        case "change_p":
          if ( $this->user )
          {
            $this->smarty->assign("user", $this->user->GetProperties() );
            $this->bPageSet = true;
          }
        break;

        case "do_change_p":
          if ( $this->user )
          {
            if ( $this->ChangePassword($info, $this->error) && empty($this->error) )
              $this->smarty->assign("info", $info);
            else if ( !empty($this->error) )
              return false;
            else
              $this->smarty->assign("warning", $info);

            $this->smarty->assign("user", $this->user->GetProperties() );
            $this->bPageSet = true;
          }           
        break;
        
        case "info":
          if ( $this->GetUserInfo($this->error) )
            $this->bPageSet = true;
          else if ( !empty($this->error) )
            return false;          
        break;
      }
      
      if ( $this->bPageSet == false )
      {
        $subMItem = $this->menuItem->GetItemByLabel("Zoznam");       
        $order = empty( $this->getParams["order"] ) ? "name" : $this->getParams["order"];       
        $userList = $this->GetItemList( $this->getParams["show"], $order);           
        $this->smarty->assign("users", $userList);           
      } 
      
      if ( $subMItem )
      {
        $this->menuItem->bSelected = false;
        $subMItem->bSelected = true;
      }
      return true;
    }
    
    function Draw()
    {
      if ( $this->bPageSet == false )
      {
        $this->smarty->assign("content", "teacherList.tpl");
        $this->smarty->assign( "title", "Zoznam učiteľov" );
      }
      else
      { 
        switch ( $this->action )
        {
          case "info":
          case "do_add":
          case "do_edit":
          case "add_course":
          case "remove_course":
            $this->smarty->assign("content", "teacherDetails.tpl");
            $this->smarty->assign( "title", "Informácie o učiteľovi" );
          break;
          
          case "add":
            $this->smarty->assign( "title", "Pridávanie učiteľa" );
            $this->smarty->assign("content", "teacherForm.tpl");
          break;
          
          case "edit":
            $this->smarty->assign( "title", "Editovanie učiteľa" );
            $this->smarty->assign("content", "teacherForm.tpl");
          break;
          
          case "delete":
            $this->smarty->assign( "title", "Vymazanie učiteľa" );
            $this->smarty->assign("content", "teacherDelete.tpl");
          break;
  
          case "search_f":
            $this->smarty->assign( "title", "Vyhľadávanie učiteľov" );
            $this->smarty->assign("content", "teacherSearch.tpl");
          break;

          case "do_search":
            $this->smarty->assign( "title", "Výsledky vyhľadávania učiteľov" );
            $this->smarty->assign("content", "teacherSearchResult.tpl");
          break;

          case "change_p":
          case "do_change_p":
            $this->smarty->assign( "title", "Zmena hesla učiteľa" );
            $this->smarty->assign("content", "teacherChangeP.tpl");
          break;
        }
      }
      parent::Draw();
    }
	}
?>
