<?php
	class cUsersPage extends cAdminPage
	{ 
    protected $menuItem;
    protected $user = NULL;
    	 
    function __construct( $smarty, $db, $action, $post, $get )
    {
      parent::__construct( $smarty, $db, $action, $post, $get );      
    }
    
    protected function VerifyUserValues(&$userValues, &$error)
    {
      $error = "";
      
      if ( empty( $this->postParams["name"] ) )
      {
        $this->smarty->assign("error", "Musíte zadať meno!" );
        return false;
      }
      else if ( empty( $this->postParams["surname"] ) )
      {
        $this->smarty->assign("error", "Musíte zadať priezvisko!" );
        return false;
      }

      $userValues["name"] = $this->postParams["name"];
      $userValues["surname"] = $this->postParams["surname"];
      $userValues["ISIC"] = $this->postParams["isic"];
      $userValues["namePrefix"] = $this->postParams["nPrefix"];
      $userValues["nameSuffix"] = $this->postParams["nSuffix"];
      return true;         
    }
    
    protected function RemoveCourse(&$error)
    {
      if ( !$this->user || is_a($this->user, "cTeacher") )
        return false;
        
      foreach ( $this->post as $key => $id )
      {
        if ( $key != "remove" )
        {          
          $this->user->RemoveCourse($key, $error);
          if ( $error )
            return false;
        }        
      }
      return true;
    }
    
    protected function GetUserInfo(&$error)
    {
      if ( $this->user )
      {
        $courseValues = array();
        $courses = $this->GetCourseList($error);
        if ( !empty( $error ) )
          return false;
          
        $usersCourses = $this->user->GetCourses($error);
        if ( $error )
          return false;
          
        for ( $i = 0; $i < count($courses); $i++ )
        {
          $bUserHasCourse = false;
          $courseValues[$i] = $courses[$i]->GetProperties();
          for ( $j = 0; $j < count($usersCourses); $j++ )
          {
            if ( $usersCourses[$j]->GetID() == $courses[$i]->GetID() )
            {
              $bUserHasCourse = true;
              break;
            }
          }
          $courseValues[$i]["signed"] = $bUserHasCourse;
        }
        usort( $courseValues, "cmpCourses");
        $this->smarty->assign("user", $this->user->GetProperties() );
        $this->smarty->assign("courses", $courseValues );
        $this->smarty->assign("userCourseCount", count($usersCourses) );
        $this->smarty->assign("courseCount", count($courses) );
        return true;
      }
      return false;
    }
		
		protected function ChangePassword(&$info, &$error)
		{
      if ( empty( $this->postParams["newP"] ) )
      {
        $info = "Musíte zadať nové heslo!";        
      }          
      else if ( $this->postParams["newP"] != $this->postParams["retypeP"] )
      {
        $info = "Zle zopakované heslo!";        
      }
      else
      { 
        $query = "UPDATE tUser SET password=MD5(CONCAT('".$this->user->GetPassPrefix().
                 "','".$this->postParams["newP"]."')) WHERE id=".$this->user->GetID().";";
        
        $result = $this->db->Query($query);
        if ( $result )
        {
          $info = "Heslo bolo úspešne zmenené.";
          return true;
        }
        $error = $this->db->GetError();
      }
      return false;
		}
		
    function Process()
    {
      return true;
    }
    
    function Draw()
    {
      parent::Draw();
    }
	}
?>
