<?php
	class cTeacherApplication extends cApplication
	{
		
		function __construct( $db )
		{
			$this->smarty = new Smarty();
			$this->smarty->template_dir = "/home/probatur/public_html/teacher/smarty/templates";
			$this->smarty->compile_dir = "/home/probatur/public_html/teacher/smarty/templates_c";
			$this->smarty->cache_dir = "/home/probatur/public_html/teacher/smarty/cache";
			$this->smarty->config_dir = "/home/probatur/public_html/teacher/smarty/configs";			
			
			$this->db = $db;
			session_start();
		}
		
		function GetPageById($pageId) 
    {
      if ( $pageId === "course" )
        return new cCoursePage($this->smarty, $this->db, $this->action, $_POST, $_GET);
      elseif ( $pageId === "proctors" ) 
        return new cProctorsPage($this->smarty, $this->db, $this->action, $_POST, $_GET);
      elseif ( $pageId === "changePassword" ) 
        return new cChangePasswordPage($this->smarty, $this->db, $this->action, $_POST, $_GET);
      elseif ( $pageId === "courseInformation" ) 
        return new cCourseInformationPage($this->smarty, $this->db, $this->action, $_POST, $_GET);
      elseif ( $pageId === "evaluation" ) 
        return new cEvaluationPage($this->smarty, $this->db, $this->action, $_POST, $_GET);
      elseif ( $pageId === "examTerms" ) 
        return new cExamTermsPage($this->smarty, $this->db, $this->action, $_POST, $_GET);
      elseif ( $pageId === "questionDB" ) 
        return new cQuestionDBPage($this->smarty, $this->db, $this->action, $_POST, $_GET);
      elseif ( $pageId === "search" ) 
        return new cSearchPage($this->smarty, $this->db, $this->action, $_POST, $_GET);
      elseif ( $pageId === "statistics" ) 
        return new cStatisticsPage($this->smarty, $this->db, $this->action, $_POST, $_GET);
      elseif ( $pageId === "userInformation" ) 
        return new cUserInformationPage($this->smarty, $this->db, $this->action, $_POST, $_GET);
      elseif ( $pageId === "testGenerating" ) 
        return new cTestGeneratingPage($this->smarty, $this->db, $this->action, $_POST, $_GET);
      elseif ( $pageId === "demoTest" ) 
        return new cDemoTestPage($this->smarty, $this->db, $this->action, $_POST, $_GET);
      elseif ( $pageId === "testImport" ) 
        return new cTestImportPage($this->smarty, $this->db, $this->action, $_POST, $_GET);
      elseif ( $pageId === "testing" ) 
        return new cTestingPage($this->smarty, $this->db, $this->action, $_POST, $_GET);
      else
        return new cInformationPage($this->smarty, $this->db, $this->action, $_POST, $_GET);
    }
    
    function Run()
    {
      $siteID = isset( $_GET["site"] ) ? $_GET["site"] : "information";
      $this->action = isset( $_GET["action"] ) ? $_GET["action"] : "";
      $this->site = $this->GetPageById($siteID);

      if ( $this->site->Process() )
      {
        if ($this->site->Redirect())
        {
          $_GET=array();
          foreach ($this->site->getParams as $key=>$value)
          {
            if (strlen($key)>3)
            {
              if (substr($key,0,3)==="red")
              {
                $s=substr($key,3,strlen($key)-3);
                $_GET[$s]=$value;
              }
            }
          }
          $_POST=$this->site->postParams;
          $siteID = isset( $_GET["site"] ) ? $_GET["site"] : "information";
          $this->action = isset( $_GET["action"] ) ? $_GET["action"] : 0;
          $this->site = $this->GetPageById($siteID);
        }
        if ($this->site->bAllowDraw) $this->site->Draw();
      }
      else
      {
        //nastala chyba
      }  	    
      session_write_close();
    }
	}
?>
